/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.http;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.transport.TransportLoggerFactory;
import org.apache.activemq.transport.TransportServer;
import org.apache.activemq.transport.http.HttpClientTransport;
import org.apache.activemq.transport.http.HttpTransportServer;
import org.apache.activemq.transport.util.TextWireFormat;
import org.apache.activemq.transport.xstream.XStreamWireFormat;
import org.apache.activemq.wireformat.WireFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpTransportFactory
extends TransportFactory {
    private static final Log LOG = LogFactory.getLog(HttpTransportFactory.class);

    public TransportServer doBind(URI location) throws IOException {
        return new HttpTransportServer(location);
    }

    protected TextWireFormat asTextWireFormat(WireFormat wireFormat) {
        if (wireFormat instanceof TextWireFormat) {
            return (TextWireFormat)wireFormat;
        }
        LOG.trace((Object)("Not created with a TextWireFormat: " + wireFormat));
        return new XStreamWireFormat();
    }

    protected String getDefaultWireFormatType() {
        return "xstream";
    }

    protected Transport createTransport(URI location, WireFormat wf) throws IOException {
        TextWireFormat textWireFormat = this.asTextWireFormat(wf);
        return new HttpClientTransport(textWireFormat, location);
    }

    public Transport compositeConfigure(Transport transport, WireFormat format, Map options) {
        HttpClientTransport httpTransport = (HttpClientTransport)super.compositeConfigure(transport, format, options);
        transport = httpTransport;
        if (httpTransport.isTrace()) {
            try {
                transport = TransportLoggerFactory.getInstance().createTransportLogger(transport);
            }
            catch (Throwable e) {
                LOG.error((Object)("Could not create TransportLogger object for: " + TransportLoggerFactory.defaultLogWriterName + ", reason: " + e), e);
            }
        }
        return transport;
    }
}

