/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import java.util.LinkedList;
import org.apache.activemq.util.BitArray;

public class BitArrayBin {
    private LinkedList<BitArray> list;
    private int maxNumberOfArrays;
    private int firstIndex = -1;
    private int firstBin = -1;
    private long lastInOrderBit = -1L;

    public BitArrayBin(int windowSize) {
        this.maxNumberOfArrays = (windowSize + 1) / 64 + 1;
        this.maxNumberOfArrays = Math.max(this.maxNumberOfArrays, 1);
        this.list = new LinkedList();
        for (int i = 0; i < this.maxNumberOfArrays; ++i) {
            this.list.add(null);
        }
    }

    public boolean setBit(long index, boolean value) {
        boolean answer = true;
        BitArray ba = this.getBitArray(index);
        if (ba != null) {
            int offset = this.getOffset(index);
            if (offset >= 0) {
                answer = ba.set(offset, value);
            }
            if (value) {
                // empty if block
            }
        }
        return answer;
    }

    public boolean isInOrder(long index) {
        boolean result = false;
        result = this.lastInOrderBit == -1L ? true : this.lastInOrderBit + 1L == index;
        this.lastInOrderBit = index;
        return result;
    }

    public boolean getBit(long index) {
        boolean answer = index >= (long)this.firstIndex;
        BitArray ba = this.getBitArray(index);
        if (ba != null) {
            int offset = this.getOffset(index);
            if (offset >= 0) {
                answer = ba.get(offset);
                return answer;
            }
        } else {
            answer = true;
        }
        return answer;
    }

    private BitArray getBitArray(long index) {
        int bin = this.getBin(index);
        BitArray answer = null;
        if (bin >= 0) {
            if (this.firstIndex < 0) {
                this.firstIndex = 0;
            }
            if (bin >= this.list.size()) {
                this.list.removeFirst();
                this.firstIndex += 64;
                this.list.add(new BitArray());
                bin = this.list.size() - 1;
            }
            if ((answer = this.list.get(bin)) == null) {
                answer = new BitArray();
                this.list.set(bin, answer);
            }
        }
        return answer;
    }

    private int getBin(long index) {
        int answer = 0;
        if (this.firstBin < 0) {
            this.firstBin = 0;
        } else if (this.firstIndex >= 0) {
            answer = (int)((index - (long)this.firstIndex) / 64L);
        }
        return answer;
    }

    private int getOffset(long index) {
        int answer = 0;
        if (this.firstIndex >= 0) {
            answer = (int)(index - (long)this.firstIndex - (long)(64 * this.getBin(index)));
        }
        return answer;
    }
}

