/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util;

import fi.csc.microarray.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.jms.JMSException;
import org.apache.log4j.Logger;

public class UrlTransferUtil {
    private static final Logger logger = Logger.getLogger(UrlTransferUtil.class);
    private static final int CHUNK_SIZE = 2048;

    public static InputStream downloadStream(URL url) throws JMSException, IOException {
        return url.openStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL uploadStream(URL url, InputStream fis, boolean useChunked, IOUtils.CopyProgressListener progressListener) throws IOException {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("PUT");
            connection.setDoOutput(true);
            logger.debug((Object)("uploading with parameters: useChunked " + useChunked + ", CHUNK_SIZE " + 2048));
            if (useChunked) {
                connection.setChunkedStreamingMode(2048);
            }
            OutputStream os = null;
            try {
                os = connection.getOutputStream();
                IOUtils.copy(fis, os, progressListener);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw e;
            }
            finally {
                IOUtils.closeIfPossible(os);
                IOUtils.closeIfPossible(fis);
            }
            if (!UrlTransferUtil.isSuccessfulCode(connection.getResponseCode())) {
                throw new IOException("PUT was not successful: " + connection.getResponseCode() + " " + connection.getResponseMessage());
            }
        }
        finally {
            IOUtils.disconnectIfPossible(connection);
        }
        return url;
    }

    private static boolean isSuccessfulCode(int responseCode) {
        return responseCode >= 200 && responseCode < 300;
    }

    public static void disableProxies() {
        ProxySelector.setDefault(new ProxySelector(){

            @Override
            public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
            }

            @Override
            public List<Proxy> select(URI uri) {
                LinkedList<Proxy> proxies = new LinkedList<Proxy>();
                proxies.add(Proxy.NO_PROXY);
                return proxies;
            }
        });
    }
}

