/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;

public class IOUtils {
    private static final int BUFFER_SIZE = 16384;
    private static final long CALLBACK_INTERVAL = 500L;

    public static void closeIfPossible(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeIfPossible(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeIfPossible(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeIfPossible(OutputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void disconnectIfPossible(HttpURLConnection connection) {
        if (connection != null) {
            connection.disconnect();
        }
    }

    public static void copy(InputStream source, OutputStream target, CopyProgressListener progressListener) throws IOException {
        byte[] buffer = new byte[16384];
        int len = 16384;
        int sum = 0;
        long lastCallback = Long.MAX_VALUE;
        if (progressListener != null) {
            progressListener.progress(0);
            lastCallback = System.currentTimeMillis();
        }
        while ((len = source.read(buffer, 0, 16384)) >= 0) {
            target.write(buffer, 0, len);
            sum += len;
            if (progressListener == null || lastCallback + 500L >= System.currentTimeMillis()) continue;
            progressListener.progress(sum);
            lastCallback = System.currentTimeMillis();
        }
    }

    public static void copy(InputStream source, OutputStream target) throws IOException {
        IOUtils.copy(source, target, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File from, File to) throws IOException {
        FileInputStream in = new FileInputStream(from);
        FileOutputStream out = new FileOutputStream(to);
        try {
            IOUtils.copy(in, out, null);
        }
        finally {
            IOUtils.closeIfPossible(in);
            IOUtils.closeIfPossible(out);
        }
    }

    public static interface CopyProgressListener {
        public void progress(int var1);
    }
}

