package org.jfree.chart.labels.junit;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import java.awt.Color;

import org.jfree.data.som.SOMDataset;
import org.jfree.data.som.SOMDataItem;
import org.jfree.chart.plot.SOMPlot;
import org.jfree.chart.labels.StandardSOMToolTipGenerator;

/**
 * Tests for the {@link StandardSOMToolTipGenerator} class.
 */
public class StandardSOMToolTipGeneratorTests extends TestCase {

 
   /**
     * Returns the tests as a test suite.
     *
     * @return The test suite.
     */
    public static Test suite() {
        return new TestSuite(StandardSOMToolTipGeneratorTests.class);
    }

    /**
     * Constructs a new set of tests.
     *
     * @param name  the name of the tests.
     */
    public StandardSOMToolTipGeneratorTests(String name) {
        super(name);
    }


    /**
     * The tests.
     */
    public void testGenerator(){

	SOMDataset dataset = new SOMDataset(2,2);
	SOMDataItem i1 = new SOMDataItem(Color.red, 
                			new String[] {new String("qazxsw"), new String("6767")}, 
                			new double[] {2.0, 0.9});
	try {
	  dataset.addValue(1, 1, i1);
	  assertTrue(true);
	} catch (IndexOutOfBoundsException e){;}
	
	StandardSOMToolTipGenerator som = new StandardSOMToolTipGenerator();
	
	String trial;
	
	// at minimum
	try {
	  trial = som.generateToolTip(null, 0, 0);
	  assertTrue(false);
	} catch (Exception e){;}

	// at one under min & one over max
	try {
	  trial = som.generateToolTip(dataset, -1, 2);
	  assertTrue(false);
	} catch (Exception e){;}

	// at maximum
	try {
	  trial = som.generateToolTip(dataset, 1, 1);
	  assertTrue(true);
	} catch (Exception e){;}

	

	

//	dtset.addValue(1,1, Color.RED, null, null);
//	String trial = null;
	
//	try {
//		trial = som.generateToolTip(new SOMDataset(1,1), 1, 1);
//	} catch (Exception e) { ; }

//		assertNotNull(trial);


//	SOMDataset dtset = new SOMDataset(1,1);
//	dataset.addValue(1, 1, Color.RED, null, null);

//	SOMPlot plot = new SOMPlot(new SOMDataset(1,1));

//	plot.setToolTipGenerator(som);
//	trial = som.generateToolTip(new SOMDataset(1,1),1,1);

//	assertNotNull(trial);

    }
}
