/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.wizard;

import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.databeans.DataBean;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultBlocker
implements Operation.ResultListener {
    private CountDownLatch latch = new CountDownLatch(1);
    private Iterable<DataBean> results;
    private int enforcedResultCount;

    public ResultBlocker() {
        this(-1);
    }

    public ResultBlocker(int enforcedResultCount) {
        this.enforcedResultCount = enforcedResultCount;
    }

    @Override
    public void resultData(Iterable<DataBean> results) {
        this.results = results;
        this.latch.countDown();
    }

    public void blockUntilDone() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public List<DataBean> getResults() {
        Iterator<DataBean> iter = this.results.iterator();
        LinkedList<DataBean> beans = new LinkedList<DataBean>();
        while (iter.hasNext()) {
            beans.add(iter.next());
        }
        if (this.enforcedResultCount != -1 && beans.size() != this.enforcedResultCount) {
            throw new IllegalStateException("there are more than " + this.enforcedResultCount + " results");
        }
        return beans;
    }
}

