/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging.message;

import fi.csc.microarray.MicroarrayConfiguration;
import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.frontend.FileBrokerConfig;
import fi.csc.microarray.messaging.message.ParameterMessage;
import fi.csc.microarray.util.IOUtils;
import fi.csc.microarray.util.UrlTransferUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PayloadMessage
extends ParameterMessage {
    private static final Logger logger = Logger.getLogger(PayloadMessage.class);
    private static final String KEY_PAYLOAD_PREFIX = "payload_";
    private Map<String, URL> payloads = new HashMap<String, URL>();
    private static boolean useChunked;

    public PayloadMessage() {
    }

    public PayloadMessage(List<String> parameters) {
        super(parameters);
    }

    @Override
    public void unmarshal(MapMessage from) throws JMSException {
        super.unmarshal(from);
        try {
            Enumeration names = from.getMapNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                logger.debug((Object)("examining " + name));
                if (!name.startsWith(KEY_PAYLOAD_PREFIX)) continue;
                String payloadName = name.substring(KEY_PAYLOAD_PREFIX.length());
                URL url = new URL(from.getString(name));
                this.payloads.put(payloadName, url);
                logger.debug((Object)("Unmarshalled " + name + " -> " + payloadName + ", " + url.toExternalForm()));
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void handleException(Exception e) throws JMSException {
        logger.error((Object)e);
        throw new JMSException(e.getMessage());
    }

    @Override
    public void marshal(MapMessage mapMessage) throws JMSException {
        super.marshal(mapMessage);
        try {
            for (String name : this.payloadNames()) {
                String key = KEY_PAYLOAD_PREFIX + name;
                String urlString = this.payloads.get(name).toExternalForm();
                mapMessage.setString(key, urlString);
                logger.debug((Object)("Marshalled " + name + " -> " + key + " " + urlString));
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public InputStream getPayload(String name) throws JMSException {
        if (this.payloads.get(name) != null) {
            URL url = this.payloads.get(name);
            InputStream payload = null;
            logger.debug((Object)("Opening input stream for " + name + " " + url.toExternalForm()));
            try {
                payload = url.openStream();
                int maxWaitTime = 30000;
                int waitTime = 10;
                while (payload.available() <= 0 && waitTime < maxWaitTime) {
                    logger.debug((Object)"Waiting for payload to become available.");
                    waitTime *= 2;
                    try {
                        Thread.sleep(waitTime);
                    }
                    catch (InterruptedException e) {
                        logger.error((Object)"Interrupted while waiting for payload to become available.");
                    }
                }
                if (payload.available() <= 0) {
                    payload = null;
                }
            }
            catch (IOException ioe) {
                logger.error((Object)("connection refused when fetching data from URL " + url));
                this.handleException(ioe);
            }
            return payload;
        }
        return null;
    }

    public URL getPayloadURL(String name) {
        return this.payloads.get(name);
    }

    public URL addPayload(String name, InputStream payload) throws JMSException {
        URL url = null;
        logger.debug((Object)("adding payload " + name));
        try {
            url = PayloadMessage.createPayloadUrl(name);
            UrlTransferUtil.uploadStream(url, payload, useChunked);
            logger.debug((Object)("successfully uploaded " + name + " to " + url));
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.payloads.put(name, url);
        return url;
    }

    public void addPayload(String payloadName, URL payloadURL) {
        this.payloads.put(payloadName, payloadURL);
    }

    public void addPayload(String payloadName, DataBean dataBean) throws JMSException, MicroarrayException, IOException {
        try {
            dataBean.updateRemoteCache(payloadName, this);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public Set<String> payloadNames() {
        return this.payloads.keySet();
    }

    @Override
    public String toString() {
        return super.toString() + ", payload count: " + this.payloadNames().size();
    }

    public Map<String, URL> getPayloads() {
        return this.payloads;
    }

    public void setPayloads(Map<String, URL> payloads) {
        this.payloads = payloads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkCachedPayload(URL cachedURL, long contentLength) {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)cachedURL.openConnection();
            if (connection.getResponseCode() != 200) {
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            IOUtils.disconnectIfPossible(connection);
        }
        return true;
    }

    private static URL createPayloadUrl(String name) throws MalformedURLException {
        String filename = UUID.randomUUID().toString() + "-" + name;
        return FileBrokerConfig.generateUrlToSomeFileBroker(filename);
    }

    static {
        String chunkedConfig = MicroarrayConfiguration.getValue("messaging", "use_chunked_http");
        useChunked = chunkedConfig == null || !chunkedConfig.equals("false");
    }
}

