/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.screen;

import fi.csc.microarray.MicroarrayConfiguration;
import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.SwingClientApplication;
import fi.csc.microarray.client.VisualConstants;
import fi.csc.microarray.client.screen.ScreenBase;
import fi.csc.microarray.client.tasks.Task;
import fi.csc.microarray.client.tasks.TaskExecutor;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.util.config.ConfigurationLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.sql.Time;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.jms.JMSException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.action.LinkAction;
import org.jdesktop.swingx.decorator.SortOrder;
import org.jdesktop.swingx.renderer.ComponentProvider;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;
import org.jdesktop.swingx.renderer.HyperlinkProvider;

public class TaskManagerScreen
extends ScreenBase
implements ActionListener,
ListSelectionListener {
    private static Logger logger = Logger.getLogger(TaskManagerScreen.class);
    private ClientApplication application = Session.getSession().getApplication();
    private Dimension BUTTON_SIZE = new Dimension(120, 22);
    private JFrame frame = new JFrame("Tasks");
    private JTextArea detailsTextArea = new JTextArea();
    private JScrollPane detailsScroller;
    private JButton detailsButton;
    private JButton closeButton;
    private JLabel operationLabel = new JLabel(" ");
    private JLabel parametersLabel = new JLabel(" ");
    private JLabel statusLabel = new JLabel(" ");
    private JLabel timeLabel = new JLabel(" ");
    private JLabel infoLabel = new JLabel(" ");
    private JXTable table;
    private TaskManagerTableModel tableModel;
    private TaskExecutor taskExecutor;
    private List<Task> tasks = new LinkedList<Task>();

    public TaskManagerScreen(TaskExecutor taskExecutor) {
        SwingClientApplication.setPlastic3DLookAndFeel(this.frame);
        this.frame.setPreferredSize(new Dimension(640, 480));
        this.frame.setLocationByPlatform(true);
        this.taskExecutor = taskExecutor;
        this.tasks.addAll(taskExecutor.getTasks(true, false));
        this.table = this.getTable();
        this.table.setSelectionBackground(this.table.getBackground());
        this.table.setSelectionForeground(this.table.getForeground());
        this.table.getColumn(Column.TIME.ordinal()).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value instanceof Date) {
                    value = new Time(((Date)value).getTime()).toString();
                }
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        });
        JScrollPane tableScroller = new JScrollPane((Component)this.table);
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(this);
        this.closeButton.setPreferredSize(this.BUTTON_SIZE);
        this.detailsScroller = new JScrollPane(this.detailsTextArea);
        this.detailsButton = new JButton("Show Details");
        this.detailsScroller.setMinimumSize(new Dimension(0, 200));
        this.detailsScroller.setVisible(false);
        this.detailsTextArea.setEditable(false);
        this.detailsButton.addActionListener(this);
        this.detailsButton.setPreferredSize(this.BUTTON_SIZE);
        this.detailsButton.setEnabled(false);
        this.frame.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 4;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.frame.add((Component)tableScroller, c);
        ++c.gridy;
        c.gridwidth = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 22;
        c.insets.bottom = 8;
        c.insets.right = 8;
        c.insets.top = 8;
        this.frame.add((Component)this.closeButton, c);
        this.frame.pack();
    }

    private JXTable getTable() {
        if (this.table == null) {
            this.tableModel = new TaskManagerTableModel();
            this.table = new JXTable(this.tableModel){

                public void updateUI() {
                    super.updateUI();
                    this.setSelectionBackground(this.getBackground());
                    this.setSelectionForeground(this.getForeground());
                }

                public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
                    Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
                    Column col = Column.values()[TaskManagerScreen.this.table.convertColumnIndexToModel(vColIndex)];
                    rowIndex = TaskManagerScreen.this.table.convertRowIndexToModel(rowIndex);
                    if (c instanceof JComponent) {
                        JComponent jc = (JComponent)c;
                        if (col == Column.TOOL) {
                            try {
                                jc.setToolTipText(((Task)TaskManagerScreen.this.tasks.get(rowIndex)).getParameters().toString());
                            }
                            catch (Exception e) {}
                        } else if (col == Column.STATUS) {
                            String status = ((Task)TaskManagerScreen.this.tasks.get(rowIndex)).getState().toString();
                            if (((Task)TaskManagerScreen.this.tasks.get(rowIndex)).getStateDetail() != null && ((Task)TaskManagerScreen.this.tasks.get(rowIndex)).getStateDetail().length() > 0) {
                                status = status + " ( " + ((Task)TaskManagerScreen.this.tasks.get(rowIndex)).getStateDetail() + " )";
                            }
                            jc.setToolTipText(status);
                        } else if (col == Column.TIME) {
                            long longTime = ((Task)TaskManagerScreen.this.tasks.get(rowIndex)).getExecutionTime();
                            jc.setToolTipText("Execution time: " + (int)(longTime / 1000L) / 60 + ":" + (int)(longTime / 1000L) % 60);
                        }
                    }
                    return c;
                }
            };
            this.table.getSelectionModel().addListSelectionListener(this);
            this.table.getColumnModel().getSelectionModel().addListSelectionListener(this);
            this.table.getSelectionModel().setSelectionMode(0);
            this.table.setAutoResizeMode(2);
            this.table.getColumnModel().getColumn(Column.ICON.ordinal()).setPreferredWidth(30);
            this.table.getColumnModel().getColumn(Column.TOOL.ordinal()).setPreferredWidth(250);
            this.table.getColumnModel().getColumn(Column.STATUS.ordinal()).setPreferredWidth(120);
            this.table.getColumnModel().getColumn(Column.TIME.ordinal()).setPreferredWidth(100);
            this.table.getColumnModel().getColumn(Column.ACTIONS.ordinal()).setPreferredWidth(55);
            this.table.setSortOrder(Column.TIME.ordinal(), SortOrder.DESCENDING);
            this.table.setRowHeight(this.table.getFontMetrics(this.table.getFont()).getHeight() * 2);
            this.table.setShowVerticalLines(false);
            LinkAction<JXHyperlink> linkAction = new LinkAction<JXHyperlink>(){

                public void actionPerformed(ActionEvent e) {
                    logger.debug((Object)("Canceling task: " + TaskManagerScreen.this.tasks.get(TaskManagerScreen.this.table.convertRowIndexToModel(TaskManagerScreen.this.table.getSelectedRow()))));
                    TaskManagerScreen.this.taskExecutor.kill((Task)TaskManagerScreen.this.tasks.get(TaskManagerScreen.this.table.convertRowIndexToModel(TaskManagerScreen.this.table.getSelectedRow())));
                    this.setVisited(true);
                }
            };
            this.table.getColumn(Column.ACTIONS.ordinal()).setCellRenderer((TableCellRenderer)new DefaultTableRenderer((ComponentProvider)new HyperlinkProvider((LinkAction)linkAction)));
        }
        return this.table;
    }

    private void refreshLabels(Task task) {
        this.detailsTextArea.setText("");
        if (task == null) {
            this.operationLabel.setText(" ");
            this.parametersLabel.setText(" ");
            this.statusLabel.setText(" ");
            this.timeLabel.setText(" ");
            this.infoLabel.setText(" ");
        } else {
            this.operationLabel.setText(task.getName());
            try {
                this.parametersLabel.setText(task.getParameters().toString());
            }
            catch (Exception e1) {
                this.parametersLabel.setText("?");
            }
            this.statusLabel.setText(task.getState().toString());
            this.timeLabel.setText(new Time(task.getStartTime()).toString());
            this.infoLabel.setText(task.getStateDetail());
            this.detailsTextArea.setText(task.getScreenOutput());
            this.detailsButton.setEnabled(task.getScreenOutput() != null && !task.getScreenOutput().equals("") || this.detailsScroller.isVisible());
        }
    }

    public void refreshTasks() {
        logger.debug((Object)"Refreshing tasks in Task manager");
        for (Task task : this.taskExecutor.getTasks(true, false)) {
            if (this.tasks.contains(task)) continue;
            logger.debug((Object)("\tNew task added: " + task.getName()));
            this.tasks.add(task);
        }
        this.tableModel.notifyListeners();
        logger.debug((Object)"Refreshing done");
    }

    public boolean hasFrame() {
        return this.frame != null;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.detailsButton) {
            if (this.detailsScroller.isVisible()) {
                this.detailsScroller.setVisible(false);
                this.detailsButton.setText("Show details");
            } else {
                this.detailsScroller.setVisible(true);
                this.detailsButton.setText("Hide details");
            }
        } else if (e.getSource() == this.closeButton) {
            this.application.flipTaskListVisibility(true);
        }
    }

    public static void main(String[] args) throws IOException, JMSException, ConfigurationLoader.OldConfigurationFormatException {
        MicroarrayConfiguration.loadConfiguration();
        new TaskManagerScreen(new TestTaskExecutor(null));
    }

    public void valueChanged(ListSelectionEvent e) {
        if (this.table.getSelectedRow() >= 0 && this.table.getSelectedRow() < this.tasks.size()) {
            this.refreshLabels(this.tasks.get(this.table.convertRowIndexToModel(this.table.getSelectedRow())));
        } else {
            this.refreshLabels(null);
        }
    }

    public int getFailedCount() {
        int i = 0;
        for (Task task : this.tasks) {
            if (task.getState() != Task.State.FAILED && task.getState() != Task.State.TIMEOUT && task.getState() != Task.State.FAILED_USER_ERROR) continue;
            ++i;
        }
        return i;
    }

    public static class TestTaskExecutor
    extends TaskExecutor {
        protected TestTaskExecutor(DataManager manager) throws JMSException {
            super(manager);
            Task task1 = new Task("Norm. 1");
            Task task2 = new Task("Norm. 2");
            Task task3 = new Task("Norm. 3");
            task2.setStateDetail("Problem with R, wrong parameters, error in data or wrong mood.");
            task1.setScreenOutput("x\n\n\n\n\n\nx\n\n\n\n\nx\tx\tx\tx\tx\tx\tx\n\n\n\nx\n\n\nx\n\n\n\n\n\n\n\n\n\n\nx\nx");
            this.addToRunningTasks(task1);
            this.addToRunningTasks(task2);
            this.addToRunningTasks(task3);
            this.removeFromRunningTasks(task1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TaskManagerTableModel
    implements TableModel {
        private LinkedList<TableModelListener> listeners = new LinkedList();

        private TaskManagerTableModel() {
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public int getRowCount() {
            return TaskManagerScreen.this.tasks.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (row >= this.getRowCount() || row < 0) {
                return null;
            }
            Column col = Column.values()[column];
            if (col == Column.ICON) {
                if (((Task)TaskManagerScreen.this.tasks.get(row)).getState().isFinished()) {
                    if (((Task)TaskManagerScreen.this.tasks.get(row)).getState().finishedSuccesfully()) {
                        return VisualConstants.SUITABLE_ICON;
                    }
                    return VisualConstants.INCOMPATIBLE_ICON;
                }
                VisualConstants.RUNNING_ICON.setImageObserver((ImageObserver)TaskManagerScreen.this.table);
                return VisualConstants.RUNNING_ICON;
            }
            if (col == Column.TOOL) {
                return ((Task)TaskManagerScreen.this.tasks.get(row)).getName().replaceAll("\"", "").replaceAll("/", " / ");
            }
            if (col == Column.STATUS) {
                String status = ((Task)TaskManagerScreen.this.tasks.get(row)).getState().toString();
                return status;
            }
            if (col == Column.TIME) {
                return new Date(((Task)TaskManagerScreen.this.tasks.get(row)).getStartTime());
            }
            if (col == Column.ACTIONS) {
                if (!((Task)TaskManagerScreen.this.tasks.get(row)).getState().isFinished()) {
                    return "Cancel";
                }
                return null;
            }
            throw new IllegalArgumentException("illegal column " + column);
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.listeners.add(l);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.getValueAt(0, columnIndex).getClass();
        }

        @Override
        public int getColumnCount() {
            return Column.values().length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return Column.values()[columnIndex].toString();
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.listeners.remove(l);
        }

        public void notifyListeners() {
            for (TableModelListener listener : this.listeners) {
                TableModelEvent tableModelEvent = new TableModelEvent(this);
                listener.tableChanged(tableModelEvent);
            }
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Column {
        ICON(""),
        TOOL("Tool"),
        TIME("Start Time"),
        STATUS("Status"),
        ACTIONS("Actions");

        private String asString;

        private Column(String asString) {
            this.asString = asString;
        }

        public String toString() {
            return this.asString;
        }
    }
}

