/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dataimport;

import fi.csc.microarray.client.dataimport.ColumnType;
import fi.csc.microarray.client.dataimport.DataColumn;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnTypePattern {
    private List<ColumnType> pattern;
    private int patternStart;

    public ColumnTypePattern(List<ColumnType> pattern, int startIndex) {
        this.patternStart = startIndex;
        this.pattern = pattern;
    }

    public List<ColumnType> getPattern() {
        return this.pattern;
    }

    public ColumnType getColumnTypeForIndex(int i) {
        if (i >= this.patternStart) {
            return this.pattern.get((i - this.patternStart) % this.pattern.size());
        }
        return null;
    }

    public static ColumnTypePattern createColumnTypePatternFromAllColumns(List<DataColumn> allColumns) {
        ColumnType column;
        int i;
        ArrayList<ColumnType> pattern = new ArrayList<ColumnType>();
        int patternEnd = -1;
        int start = -1;
        for (i = allColumns.size() - 1; i > 0; --i) {
            column = allColumns.get(i).getColumnType();
            if (column.equals((Object)ColumnType.UNUSED_LABEL)) continue;
            if (patternEnd == -1) {
                patternEnd = i;
                continue;
            }
            if (!column.equals((Object)allColumns.get(patternEnd).getColumnType())) continue;
            start = i + 1;
            break;
        }
        if (patternEnd == -1) {
            return new ColumnTypePattern(pattern, Integer.MAX_VALUE);
        }
        if (start == -1) {
            for (i = 1; i < patternEnd; ++i) {
                column = allColumns.get(i).getColumnType();
                if (column.equals((Object)ColumnType.UNUSED_LABEL)) continue;
                start = i;
                break;
            }
        }
        if (start == -1) {
            start = patternEnd;
        }
        for (i = start; i <= patternEnd; ++i) {
            column = allColumns.get(i).getColumnType();
            pattern.add(column);
        }
        return new ColumnTypePattern(pattern, start);
    }

    public String toString() {
        StringBuffer pattern = new StringBuffer();
        for (ColumnType column : this.getPattern()) {
            pattern.append(column.getIdentifier());
            pattern.append(" - ");
        }
        return "Column type pattern: " + pattern.toString();
    }
}

