/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uif_lite.panel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import org.apache.log4j.Logger;

public class SimpleInternalFrame
extends JPanel
implements MouseListener {
    private static final Logger logger = Logger.getLogger(SimpleInternalFrame.class);
    private final int SPLIT_MARGIN = 6;
    private JLabel titleLabel;
    private JPanel gradientPanel;
    private JPanel headerPanel;
    private boolean selected = false;
    private boolean paintGradient;
    private boolean paintTitleBorder;
    private static final double FACTOR = 0.9;

    public SimpleInternalFrame(String title) {
        this(null, title, null, null);
    }

    public SimpleInternalFrame(Icon icon, String title) {
        this(icon, title, null, null);
    }

    public SimpleInternalFrame(String title, JToolBar bar, JComponent content) {
        this(null, title, bar, content);
    }

    public SimpleInternalFrame(Icon icon, String title, JToolBar bar, JComponent content) {
        super(new BorderLayout());
        this.titleLabel = new JLabel(title, icon, 10);
        this.titleLabel.setFont(this.getTittleFont());
        this.addMouseListener(this);
        this.paintGradient = true;
        this.paintTitleBorder = false;
        JPanel top = this.buildHeader(this.titleLabel, bar);
        this.add((Component)top, "North");
        if (content != null) {
            this.setContent(content);
        }
        this.setBorder(new ShadowBorder());
        this.setSelected(true);
        this.updateHeader();
    }

    public Icon getFrameIcon() {
        return this.titleLabel.getIcon();
    }

    public void setFrameIcon(Icon newIcon) {
        Icon oldIcon = this.getFrameIcon();
        this.titleLabel.setIcon(newIcon);
        this.firePropertyChange("frameIcon", oldIcon, newIcon);
    }

    public String getTitle() {
        return this.titleLabel.getText();
    }

    public void setTitle(String newText) {
        String oldText = this.getTitle();
        this.titleLabel.setText(newText);
        this.firePropertyChange("title", oldText, newText);
    }

    public JToolBar getToolBar() {
        return this.headerPanel.getComponentCount() > 1 ? (JToolBar)this.headerPanel.getComponent(1) : null;
    }

    public void setToolBar(JToolBar newToolBar) {
        JToolBar oldToolBar = this.getToolBar();
        if (oldToolBar == newToolBar) {
            return;
        }
        if (oldToolBar != null) {
            this.headerPanel.remove(oldToolBar);
        }
        if (newToolBar != null) {
            newToolBar.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.headerPanel.add((Component)newToolBar, "South");
        }
        this.updateHeader();
        this.firePropertyChange("toolBar", oldToolBar, newToolBar);
    }

    public Component getContent() {
        return this.hasContent() ? this.getComponent(1) : null;
    }

    public void setContent(Component newContent) {
        Component oldContent = this.getContent();
        if (this.hasContent()) {
            this.remove(oldContent);
        }
        this.add(newContent, "Center");
        this.firePropertyChange("content", oldContent, newContent);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isMaximized() {
        if (this.getParent() instanceof JSplitPane) {
            JSplitPane split = (JSplitPane)this.getParent();
            if (split.getTopComponent() == this) {
                if (split.getDividerLocation() == split.getHeight() - (this.gradientPanel.getHeight() + split.getDividerSize() + 6)) {
                    logger.debug((Object)"is a maximized top component");
                    return true;
                }
                logger.debug((Object)"is not a maximized component, but it is a top component");
                return false;
            }
            if (split.getDividerLocation() == this.gradientPanel.getHeight()) {
                logger.debug((Object)"is a maximized bottom component");
                return true;
            }
            logger.debug((Object)"is not a maximized component, but is is a bottom component");
            return false;
        }
        throw new IllegalStateException("SimpleInternalFrame is not on a split pane");
    }

    public void setSelected(boolean newValue) {
        boolean oldValue = this.isSelected();
        this.selected = newValue;
        this.updateHeader();
        this.firePropertyChange("selected", oldValue, newValue);
    }

    private JPanel buildHeader(JLabel label, JToolBar bar) {
        this.gradientPanel = this.paintGradient ? new GradientPanel(new BorderLayout(), SimpleInternalFrame.getHeaderBackground()) : new JPanel(new BorderLayout());
        label.setOpaque(false);
        this.gradientPanel.add((Component)label, "West");
        this.gradientPanel.setBorder(BorderFactory.createEmptyBorder(3, 4, 3, 1));
        this.headerPanel = new JPanel(new BorderLayout());
        this.headerPanel.add((Component)this.gradientPanel, "Center");
        this.setToolBar(bar);
        if (this.paintTitleBorder) {
            this.headerPanel.setBorder(new RaisedHeaderBorder());
        }
        this.headerPanel.setOpaque(false);
        return this.headerPanel;
    }

    private void updateHeader() {
        this.gradientPanel.setBackground(SimpleInternalFrame.getHeaderBackground());
        this.titleLabel.setFont(this.getTittleFont());
        this.titleLabel.setForeground(this.getTextForeground(this.isSelected()));
        this.headerPanel.repaint();
    }

    public void updateUI() {
        super.updateUI();
        if (this.titleLabel != null) {
            this.updateHeader();
        }
    }

    private boolean hasContent() {
        return this.getComponentCount() > 1;
    }

    protected Color getTextForeground(boolean isSelected) {
        Color c = UIManager.getColor(isSelected ? "SimpleInternalFrame.activeTitleForeground" : "SimpleInternalFrame.inactiveTitleForeground");
        if (c != null) {
            return c;
        }
        return UIManager.getColor(isSelected ? "InternalFrame.activeTitleForeground" : "Label.foreground");
    }

    protected Font getTittleFont() {
        return UIManager.getFont("Label.font").deriveFont(1);
    }

    protected static Color getHeaderBackground() {
        Color c = UIManager.getColor("SimpleInternalFrame.activeTitleBackground");
        return c != null ? c : UIManager.getColor("InternalFrame.activeTitleBackground");
    }

    public static void multipleGradients(Graphics2D g2, int width, int height, Color background) {
        Color startColor = SimpleInternalFrame.brighten(SimpleInternalFrame.brighten(SimpleInternalFrame.brighten(background)));
        Color endColor = background;
        int startHeight = (int)((double)height * 0.0 / 4.0);
        int endHeight = (int)((double)height * 1.0 / 4.0);
        g2.setPaint(new GradientPaint(0.0f, startHeight, startColor, 0.0f, endHeight, endColor));
        g2.fillRect(0, startHeight, width, endHeight);
        startColor = background;
        endColor = background;
        startHeight = (int)((double)height * 1.0 / 4.0);
        endHeight = (int)((double)height * 2.0 / 4.0);
        g2.setPaint(new GradientPaint(0.0f, startHeight, startColor, 0.0f, endHeight, endColor));
        g2.fillRect(0, startHeight, width, endHeight);
        startColor = background;
        endColor = SimpleInternalFrame.brighten(background);
        startHeight = (int)((double)height * 2.0 / 4.0);
        endHeight = (int)((double)height * 3.0 / 4.0);
        g2.setPaint(new GradientPaint(0.0f, startHeight, startColor, 0.0f, endHeight, endColor));
        g2.fillRect(0, startHeight, width, endHeight);
        startColor = SimpleInternalFrame.brighten(background);
        endColor = SimpleInternalFrame.darken(SimpleInternalFrame.darken(background));
        startHeight = (int)((double)height * 3.0 / 4.0);
        endHeight = (int)((double)height * 4.0 / 4.0);
        g2.setPaint(new GradientPaint(0.0f, startHeight, startColor, 0.0f, endHeight, endColor));
        g2.fillRect(0, startHeight, width, endHeight);
    }

    public static Color darken(Color c) {
        return new Color(Math.max((int)((double)c.getRed() * 0.9), 0), Math.max((int)((double)c.getGreen() * 0.9), 0), Math.max((int)((double)c.getBlue() * 0.9), 0));
    }

    public static Color brighten(Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int i = 10;
        if (r == 0 && g == 0 && b == 0) {
            return new Color(i, i, i);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return new Color(Math.min((int)((double)r / 0.9), 255), Math.min((int)((double)g / 0.9), 255), Math.min((int)((double)b / 0.9), 255));
    }

    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2 && this.getParent() instanceof JSplitPane) {
            JSplitPane split = (JSplitPane)this.getParent();
            if (split.getTopComponent() == this) {
                if (!this.isMaximized()) {
                    split.setDividerLocation(split.getHeight() - (this.gradientPanel.getHeight() + split.getDividerSize() + 6));
                    if (split.getBottomComponent() instanceof SimpleInternalFrame) {
                        ((SimpleInternalFrame)split.getBottomComponent()).getContent().setVisible(false);
                        ((SimpleInternalFrame)split.getBottomComponent()).getToolBar().setVisible(false);
                    }
                } else {
                    split.setDividerLocation(split.getLastDividerLocation());
                    if (split.getBottomComponent() instanceof SimpleInternalFrame) {
                        ((SimpleInternalFrame)split.getBottomComponent()).getContent().setVisible(true);
                        ((SimpleInternalFrame)split.getBottomComponent()).getToolBar().setVisible(true);
                    }
                }
            } else if (!this.isMaximized()) {
                split.setDividerLocation(this.gradientPanel.getHeight());
                if (split.getBottomComponent() instanceof SimpleInternalFrame) {
                    ((SimpleInternalFrame)split.getBottomComponent()).getContent().setVisible(false);
                }
            } else {
                split.setDividerLocation(split.getLastDividerLocation());
                if (split.getBottomComponent() instanceof SimpleInternalFrame) {
                    ((SimpleInternalFrame)split.getBottomComponent()).getContent().setVisible(true);
                    ((SimpleInternalFrame)split.getBottomComponent()).getToolBar().setVisible(true);
                }
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    private static final class GradientPanel
    extends JPanel {
        private GradientPanel(LayoutManager lm, Color background) {
            super(lm);
            this.setBackground(background);
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (!this.isOpaque()) {
                return;
            }
            int width = this.getWidth();
            int height = this.getHeight();
            Graphics2D g2 = (Graphics2D)g;
            Paint storedPaint = g2.getPaint();
            SimpleInternalFrame.multipleGradients(g2, width, height, SimpleInternalFrame.getHeaderBackground());
            g2.setPaint(storedPaint);
        }
    }

    private static class ShadowBorder
    extends AbstractBorder {
        private static final Insets INSETS = new Insets(1, 1, 3, 3);

        private ShadowBorder() {
        }

        public Insets getBorderInsets(Component c) {
            return INSETS;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Color shadow = UIManager.getColor("controlShadow");
            if (shadow == null) {
                shadow = Color.GRAY;
            }
            Color lightShadow = new Color(shadow.getRed(), shadow.getGreen(), shadow.getBlue(), 170);
            Color lighterShadow = new Color(shadow.getRed(), shadow.getGreen(), shadow.getBlue(), 70);
            g.translate(x, y);
            g.setColor(shadow);
            g.fillRect(0, 0, w - 3, 1);
            g.fillRect(0, 0, 1, h - 3);
            g.fillRect(w - 3, 1, 1, h - 3);
            g.fillRect(1, h - 3, w - 3, 1);
            g.setColor(lightShadow);
            g.fillRect(w - 3, 0, 1, 1);
            g.fillRect(0, h - 3, 1, 1);
            g.fillRect(w - 2, 1, 1, h - 3);
            g.fillRect(1, h - 2, w - 3, 1);
            g.setColor(lighterShadow);
            g.fillRect(w - 2, 0, 1, 1);
            g.fillRect(0, h - 2, 1, 1);
            g.fillRect(w - 2, h - 2, 1, 1);
            g.fillRect(w - 1, 1, 1, h - 2);
            g.fillRect(1, h - 1, w - 2, 1);
            g.translate(-x, -y);
        }
    }

    private static class RaisedHeaderBorder
    extends AbstractBorder {
        private static Insets INSETS = new Insets(1, 1, 1, 0);

        private RaisedHeaderBorder() {
        }

        public Insets getBorderInsets(Component c) {
            return INSETS;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            g.setColor(UIManager.getColor("controlLtHighlight"));
            g.fillRect(0, 0, w, 1);
            g.fillRect(0, 1, 1, h - 1);
            g.setColor(UIManager.getColor("controlShadow"));
            g.fillRect(0, h - 1, w, 1);
            g.translate(-x, -y);
        }
    }
}

