/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Star2D
implements Shape {
    private Shape starShape;
    private double x;
    private double y;
    private double innerRadius;
    private double outerRadius;
    private int branchesCount;

    public Star2D(double x, double y, double innerRadius, double outerRadius, int branchesCount) {
        if (branchesCount <= 2) {
            throw new IllegalArgumentException("The number of branches must be >= 3.");
        }
        if (innerRadius >= outerRadius) {
            throw new IllegalArgumentException("The inner radius must be < outer radius.");
        }
        this.x = x;
        this.y = y;
        this.innerRadius = innerRadius;
        this.outerRadius = outerRadius;
        this.branchesCount = branchesCount;
        this.starShape = Star2D.generateStar(x, y, innerRadius, outerRadius, branchesCount);
    }

    private static Shape generateStar(double x, double y, double innerRadius, double outerRadius, int branchesCount) {
        GeneralPath path = new GeneralPath();
        double outerAngleIncrement = Math.PI * 2 / (double)branchesCount;
        double outerAngle = 0.0;
        double innerAngle = outerAngleIncrement / 2.0;
        float x1 = (float)(Math.cos(outerAngle) * outerRadius + (x += outerRadius));
        float y1 = (float)(Math.sin(outerAngle) * outerRadius + (y += outerRadius));
        float x2 = (float)(Math.cos(innerAngle) * innerRadius + x);
        float y2 = (float)(Math.sin(innerAngle) * innerRadius + y);
        path.moveTo(x1, y1);
        path.lineTo(x2, y2);
        outerAngle += outerAngleIncrement;
        innerAngle += outerAngleIncrement;
        for (int i = 1; i < branchesCount; ++i) {
            x1 = (float)(Math.cos(outerAngle) * outerRadius + x);
            y1 = (float)(Math.sin(outerAngle) * outerRadius + y);
            path.lineTo(x1, y1);
            x2 = (float)(Math.cos(innerAngle) * innerRadius + x);
            y2 = (float)(Math.sin(innerAngle) * innerRadius + y);
            path.lineTo(x2, y2);
            outerAngle += outerAngleIncrement;
            innerAngle += outerAngleIncrement;
        }
        path.closePath();
        return path;
    }

    public void setInnerRadius(double innerRadius) {
        if (innerRadius >= this.outerRadius) {
            throw new IllegalArgumentException("The inner radius must be < outer radius.");
        }
        this.innerRadius = innerRadius;
        this.starShape = Star2D.generateStar(this.getX(), this.getY(), innerRadius, this.getOuterRadius(), this.getBranchesCount());
    }

    public void setX(double x) {
        this.x = x;
        this.starShape = Star2D.generateStar(x, this.getY(), this.getInnerRadius(), this.getOuterRadius(), this.getBranchesCount());
    }

    public void setY(double y) {
        this.y = y;
        this.starShape = Star2D.generateStar(this.getX(), y, this.getInnerRadius(), this.getOuterRadius(), this.getBranchesCount());
    }

    public void setOuterRadius(double outerRadius) {
        if (this.innerRadius >= outerRadius) {
            throw new IllegalArgumentException("The outer radius must be > inner radius.");
        }
        this.outerRadius = outerRadius;
        this.starShape = Star2D.generateStar(this.getX(), this.getY(), this.getInnerRadius(), outerRadius, this.getBranchesCount());
    }

    public void setBranchesCount(int branchesCount) {
        if (branchesCount <= 2) {
            throw new IllegalArgumentException("The number of branches must be >= 3.");
        }
        this.branchesCount = branchesCount;
        this.starShape = Star2D.generateStar(this.getX(), this.getY(), this.getInnerRadius(), this.getOuterRadius(), branchesCount);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getInnerRadius() {
        return this.innerRadius;
    }

    public double getOuterRadius() {
        return this.outerRadius;
    }

    public int getBranchesCount() {
        return this.branchesCount;
    }

    public Rectangle getBounds() {
        return this.starShape.getBounds();
    }

    public Rectangle2D getBounds2D() {
        return this.starShape.getBounds2D();
    }

    public boolean contains(double x, double y) {
        return this.starShape.contains(x, y);
    }

    public boolean contains(Point2D p) {
        return this.starShape.contains(p);
    }

    public boolean intersects(double x, double y, double w, double h) {
        return this.starShape.intersects(x, y, w, h);
    }

    public boolean intersects(Rectangle2D r) {
        return this.starShape.intersects(r);
    }

    public boolean contains(double x, double y, double w, double h) {
        return this.starShape.contains(x, y, w, h);
    }

    public boolean contains(Rectangle2D r) {
        return this.starShape.contains(r);
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return this.starShape.getPathIterator(at);
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.starShape.getPathIterator(at, flatness);
    }
}

