/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.Topic;
import org.apache.activemq.test.JmsTopicSendReceiveTest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JmsQueueCompositeSendReceiveTest
extends JmsTopicSendReceiveTest {
    private static final Log LOG = LogFactory.getLog(JmsQueueCompositeSendReceiveTest.class);

    protected void setUp() throws Exception {
        this.topic = false;
        this.deliveryMode = 1;
        super.setUp();
    }

    protected String getConsumerSubject() {
        return "FOO.BAR.HUMBUG";
    }

    protected String getProducerSubject() {
        return "FOO.BAR.HUMBUG,FOO.BAR.HUMBUG2";
    }

    public void testSendReceive() throws Exception {
        super.testSendReceive();
        this.messages.clear();
        Queue consumerDestination = this.consumeSession.createQueue("FOO.BAR.HUMBUG2");
        LOG.info("Created  consumer destination: " + consumerDestination + " of type: " + consumerDestination.getClass());
        MessageConsumer consumer = null;
        if (this.durable) {
            LOG.info("Creating durable consumer");
            consumer = this.consumeSession.createDurableSubscriber((Topic)((Object)consumerDestination), this.getName());
        } else {
            consumer = this.consumeSession.createConsumer(consumerDestination);
        }
        consumer.setMessageListener(this);
        this.assertMessagesAreReceived();
        LOG.info("" + this.data.length + " messages(s) received, closing down connections");
    }
}

