/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.antlr.Tool;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.test.ErrorQueue;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Message;

public abstract class BaseTest
extends TestCase {
    public static final String jikes = null;
    public static final String pathSep = System.getProperty("path.separator");
    public static final String CLASSPATH = System.getProperty("java.class.path");
    public static final String tmpdir = new File(System.getProperty("java.io.tmpdir"), "antlr3").getAbsolutePath();

    protected Tool newTool() {
        Tool tool = new Tool();
        tool.setOutputDirectory(tmpdir);
        return tool;
    }

    protected boolean compile(String string) {
        String string2 = "javac";
        String string3 = "-classpath";
        if (jikes != null) {
            string2 = jikes;
            string3 = "-bootclasspath";
        }
        String[] stringArray = new String[]{string2, "-d", tmpdir, string3, tmpdir + pathSep + CLASSPATH, tmpdir + "/" + string};
        String string4 = string2 + " -d " + tmpdir + " " + string3 + " " + tmpdir + pathSep + CLASSPATH + " " + string;
        File file = new File(tmpdir);
        try {
            int n;
            Process process = Runtime.getRuntime().exec(stringArray, null, file);
            StreamVacuum streamVacuum = new StreamVacuum(process.getInputStream());
            StreamVacuum streamVacuum2 = new StreamVacuum(process.getErrorStream());
            streamVacuum.start();
            streamVacuum2.start();
            process.waitFor();
            if (streamVacuum.toString().length() > 0) {
                System.err.println("compile stderr from: " + string4);
                System.err.println(streamVacuum);
            }
            if (streamVacuum2.toString().length() > 0) {
                System.err.println("compile stderr from: " + string4);
                System.err.println(streamVacuum2);
            }
            return (n = process.exitValue()) == 0;
        }
        catch (Exception exception) {
            System.err.println("can't exec compilation");
            exception.printStackTrace(System.err);
            return false;
        }
    }

    protected boolean antlr(String string, String string2, String string3, boolean bl) {
        boolean bl2 = true;
        this.mkdir(tmpdir);
        this.writeFile(tmpdir, string, string3);
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (bl) {
                arrayList.add("-debug");
            }
            arrayList.add("-o");
            arrayList.add(tmpdir);
            arrayList.add("-lib");
            arrayList.add(tmpdir);
            arrayList.add(new File(tmpdir, string2).toString());
            String[] stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            ErrorQueue errorQueue = new ErrorQueue();
            ErrorManager.setErrorListener(errorQueue);
            Tool tool = new Tool(stringArray);
            tool.process();
            if (errorQueue.errors.size() > 0) {
                bl2 = false;
                System.err.println("antlr reports errors from " + arrayList);
                for (int i = 0; i < errorQueue.errors.size(); ++i) {
                    Message message = (Message)errorQueue.errors.get(i);
                    System.err.println(message);
                }
            }
        }
        catch (Exception exception) {
            bl2 = false;
            System.err.println("problems building grammar: " + exception);
            exception.printStackTrace(System.err);
        }
        return bl2;
    }

    protected String execParser(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) {
        this.eraseFiles(".class");
        this.eraseFiles(".java");
        this.rawGenerateAndBuildRecognizer(string, string2, string3, string4, bl);
        this.writeFile(tmpdir, "input", string6);
        boolean bl2 = string2.indexOf("output=AST") >= 0 || string2.indexOf("output = AST") >= 0;
        boolean bl3 = string2.indexOf("output=template") >= 0 || string2.indexOf("output = template") >= 0;
        return this.rawExecRecognizer(string3, null, string4, string5, null, bl2, bl3, bl);
    }

    protected String execTreeParser(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) {
        return this.execTreeParser(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, false);
    }

    protected String execTreeParser(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, boolean bl) {
        this.eraseFiles(".class");
        this.eraseFiles(".java");
        this.rawGenerateAndBuildRecognizer(string, string2, string3, string7, bl);
        this.rawGenerateAndBuildRecognizer(string4, string5, string6, string7, bl);
        this.writeFile(tmpdir, "input", string10);
        boolean bl2 = string2.indexOf("output=AST") >= 0;
        boolean bl3 = string2.indexOf("output=template") >= 0;
        return this.rawExecRecognizer(string3, string6, string7, string8, string9, bl2, bl3, bl);
    }

    protected boolean rawGenerateAndBuildRecognizer(String string, String string2, String string3, String string4, boolean bl) {
        boolean bl2 = this.antlr(string, string, string2, bl);
        if (string4 != null) {
            boolean bl3;
            if (string3 != null && !(bl3 = this.compile(string3 + ".java"))) {
                bl2 = false;
            }
            if (!(bl3 = this.compile(string4 + ".java"))) {
                bl2 = false;
            }
        } else {
            boolean bl4 = this.compile(string3 + ".java");
            if (!bl4) {
                bl2 = false;
            }
        }
        return bl2;
    }

    protected String rawExecRecognizer(String string, String string2, String string3, String string4, String string5, boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            this.writeTreeTestFile(string, string2, string3, string4, string5, bl3);
        } else if (bl2) {
            this.writeTemplateTestFile(string, string3, string4, bl3);
        } else {
            this.writeTestFile(string, string3, string4, bl3);
        }
        this.compile("Test.java");
        try {
            String[] stringArray = new String[]{"java", "-classpath", CLASSPATH + pathSep + tmpdir, "Test", new File(tmpdir, "input").getAbsolutePath()};
            String string6 = "java -classpath " + CLASSPATH + pathSep + tmpdir + " Test " + new File(tmpdir, "input").getAbsolutePath();
            Process process = Runtime.getRuntime().exec(stringArray, null, new File(tmpdir));
            StreamVacuum streamVacuum = new StreamVacuum(process.getInputStream());
            StreamVacuum streamVacuum2 = new StreamVacuum(process.getErrorStream());
            streamVacuum.start();
            streamVacuum2.start();
            process.waitFor();
            streamVacuum.join();
            streamVacuum2.join();
            String string7 = null;
            string7 = streamVacuum.toString();
            if (streamVacuum2.toString().length() > 0) {
                System.err.println("exec parser stderr: " + streamVacuum2);
            }
            return string7;
        }
        catch (Exception exception) {
            System.err.println("can't exec parser");
            exception.printStackTrace(System.err);
            return null;
        }
    }

    protected void writeFile(String string, String string2, String string3) {
        try {
            File file = new File(string, string2);
            FileWriter fileWriter = new FileWriter(file);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(string3);
            bufferedWriter.close();
            fileWriter.close();
        }
        catch (IOException iOException) {
            System.err.println("can't write file");
            iOException.printStackTrace(System.err);
        }
    }

    protected void mkdir(String string) {
        File file = new File(string);
        file.mkdirs();
    }

    protected void writeTestFile(String string, String string2, String string3, boolean bl) {
        StringTemplate stringTemplate = new StringTemplate("import org.antlr.runtime.*;\nimport org.antlr.runtime.tree.*;\nimport org.antlr.runtime.debug.*;\n\nclass Profiler2 extends Profiler {\n    public void terminate() { ; }\n}\npublic class Test {\n    public static void main(String[] args) throws Exception {\n        CharStream input = new ANTLRFileStream(args[0]);\n        $lexerName$ lex = new $lexerName$(input);\n        CommonTokenStream tokens = new CommonTokenStream(lex);\n        $createParser$\n        parser.$parserStartRuleName$();\n    }\n}");
        StringTemplate stringTemplate2 = new StringTemplate("        Profiler2 profiler = new Profiler2();\n        $parserName$ parser = new $parserName$(tokens,profiler);\n        profiler.setParser(parser);\n");
        if (!bl) {
            stringTemplate2 = new StringTemplate("        $parserName$ parser = new $parserName$(tokens);\n");
        }
        stringTemplate.setAttribute("createParser", stringTemplate2);
        stringTemplate.setAttribute("parserName", string);
        stringTemplate.setAttribute("lexerName", string2);
        stringTemplate.setAttribute("parserStartRuleName", string3);
        this.writeFile(tmpdir, "Test.java", stringTemplate.toString());
    }

    protected void writeTreeTestFile(String string, String string2, String string3, String string4, String string5, boolean bl) {
        StringTemplate stringTemplate = new StringTemplate("import org.antlr.runtime.*;\nimport org.antlr.runtime.tree.*;\nimport org.antlr.runtime.debug.*;\n\nclass Profiler2 extends Profiler {\n    public void terminate() { ; }\n}\npublic class Test {\n    public static void main(String[] args) throws Exception {\n        CharStream input = new ANTLRFileStream(args[0]);\n        $lexerName$ lex = new $lexerName$(input);\n        TokenRewriteStream tokens = new TokenRewriteStream(lex);\n        $createParser$\n        $parserName$.$parserStartRuleName$_return r = parser.$parserStartRuleName$();\n        $if(!treeParserStartRuleName)$\n        if ( r.tree!=null )\n            System.out.println(((Tree)r.tree).toStringTree());\n        $else$\n        CommonTreeNodeStream nodes = new CommonTreeNodeStream((Tree)r.tree);\n        nodes.setTokenStream(tokens);\n        $treeParserName$ walker = new $treeParserName$(nodes);\n        walker.$treeParserStartRuleName$();\n        $endif$\n    }\n}");
        StringTemplate stringTemplate2 = new StringTemplate("        Profiler2 profiler = new Profiler2();\n        $parserName$ parser = new $parserName$(tokens,profiler);\n        profiler.setParser(parser);\n");
        if (!bl) {
            stringTemplate2 = new StringTemplate("        $parserName$ parser = new $parserName$(tokens);\n");
        }
        stringTemplate.setAttribute("createParser", stringTemplate2);
        stringTemplate.setAttribute("parserName", string);
        stringTemplate.setAttribute("treeParserName", string2);
        stringTemplate.setAttribute("lexerName", string3);
        stringTemplate.setAttribute("parserStartRuleName", string4);
        stringTemplate.setAttribute("treeParserStartRuleName", string5);
        this.writeFile(tmpdir, "Test.java", stringTemplate.toString());
    }

    protected void writeTemplateTestFile(String string, String string2, String string3, boolean bl) {
        StringTemplate stringTemplate = new StringTemplate("import org.antlr.runtime.*;\nimport org.antlr.stringtemplate.*;\nimport org.antlr.stringtemplate.language.*;\nimport org.antlr.runtime.debug.*;\nimport java.io.*;\n\nclass Profiler2 extends Profiler {\n    public void terminate() { ; }\n}\npublic class Test {\n    static String templates =\n    \t\t\"group test;\"+    \t\t\"foo(x,y) ::= \\\"<x> <y>\\\"\";\n    static StringTemplateGroup group =    \t\tnew StringTemplateGroup(new StringReader(templates),\t\t\t\t\tAngleBracketTemplateLexer.class);    public static void main(String[] args) throws Exception {\n        CharStream input = new ANTLRFileStream(args[0]);\n        $lexerName$ lex = new $lexerName$(input);\n        CommonTokenStream tokens = new CommonTokenStream(lex);\n        $createParser$\n\t\t parser.setTemplateLib(group);\n        $parserName$.$parserStartRuleName$_return r = parser.$parserStartRuleName$();\n        if ( r.st!=null )\n            System.out.print(r.st.toString());\n\t \t else\n            System.out.print(\"\");\n    }\n}");
        StringTemplate stringTemplate2 = new StringTemplate("        Profiler2 profiler = new Profiler2();\n        $parserName$ parser = new $parserName$(tokens,profiler);\n        profiler.setParser(parser);\n");
        if (!bl) {
            stringTemplate2 = new StringTemplate("        $parserName$ parser = new $parserName$(tokens);\n");
        }
        stringTemplate.setAttribute("createParser", stringTemplate2);
        stringTemplate.setAttribute("parserName", string);
        stringTemplate.setAttribute("lexerName", string2);
        stringTemplate.setAttribute("parserStartRuleName", string3);
        this.writeFile(tmpdir, "Test.java", stringTemplate.toString());
    }

    protected void eraseFiles(String string) {
        File file = new File(tmpdir);
        String[] stringArray = file.list();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith(string)) continue;
            new File(tmpdir + "/" + stringArray[i]).delete();
        }
    }

    public static class StreamVacuum
    implements Runnable {
        StringBuffer buf = new StringBuffer();
        BufferedReader in;
        Thread sucker;

        public StreamVacuum(InputStream inputStream) {
            this.in = new BufferedReader(new InputStreamReader(inputStream));
        }

        public void start() {
            this.sucker = new Thread(this);
            this.sucker.start();
        }

        public void run() {
            try {
                String string = this.in.readLine();
                while (string != null) {
                    this.buf.append(string);
                    this.buf.append('\n');
                    string = this.in.readLine();
                }
            }
            catch (IOException iOException) {
                System.err.println("can't read output from process");
            }
        }

        public void join() throws InterruptedException {
            this.sucker.join();
        }

        public String toString() {
            return this.buf.toString();
        }
    }
}

