/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods;

import fi.csc.microarray.client.visualisation.methods.Scatterplot;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.ShapeUtilities;
import org.jfree.util.UnitType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PositionRecordingRenderer
extends StandardXYItemRenderer {
    protected List<Scatterplot.DataItem2D> allItems = new LinkedList<Scatterplot.DataItem2D>();
    protected Set<Scatterplot.DataItem2D> selectedItems = new HashSet<Scatterplot.DataItem2D>();
    protected ChartPanel chartPanel;

    public PositionRecordingRenderer(int shapes, List<Scatterplot.DataItem2D> allItems, Set<Scatterplot.DataItem2D> selectedItems, ChartPanel chartPanel) {
        super(shapes);
        this.allItems = allItems;
        this.selectedItems = selectedItems;
        this.chartPanel = chartPanel;
    }

    @Override
    public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        Image image;
        boolean itemVisible = this.getItemVisible(series, item);
        Shape entityArea = null;
        EntityCollection entities = null;
        if (info != null) {
            entities = info.getOwner().getEntityCollection();
        }
        PlotOrientation orientation = plot.getOrientation();
        Paint paint = this.getItemPaint(series, item);
        Stroke seriesStroke = this.getItemStroke(series, item);
        g2.setPaint(paint);
        g2.setStroke(seriesStroke);
        double x1 = dataset.getXValue(series, item);
        double y1 = dataset.getYValue(series, item);
        if (Double.isNaN(x1) || Double.isNaN(y1)) {
            itemVisible = false;
        }
        RectangleEdge xAxisLocation = plot.getDomainAxisEdge();
        RectangleEdge yAxisLocation = plot.getRangeAxisEdge();
        double transX1 = domainAxis.valueToJava2D(x1, dataArea, xAxisLocation);
        double transY1 = rangeAxis.valueToJava2D(y1, dataArea, yAxisLocation);
        if (this.getPlotLines()) {
            if (this.getDrawSeriesLineAsPath()) {
                StandardXYItemRenderer.State s = (StandardXYItemRenderer.State)state;
                if (s.getSeriesIndex() != series) {
                    s.setLastPointGood(false);
                    s.setSeriesIndex(series);
                }
                if (itemVisible && !Double.isNaN(transX1) && !Double.isNaN(transY1)) {
                    float x = (float)transX1;
                    float y = (float)transY1;
                    if (orientation == PlotOrientation.HORIZONTAL) {
                        x = (float)transY1;
                        y = (float)transX1;
                    }
                    if (s.isLastPointGood()) {
                        s.seriesPath.lineTo(x, y);
                    } else {
                        s.seriesPath.moveTo(x, y);
                    }
                    s.setLastPointGood(true);
                } else {
                    s.setLastPointGood(false);
                }
                if (item == dataset.getItemCount(series) - 1 && s.getSeriesIndex() == series) {
                    g2.setStroke(this.getSeriesStroke(series));
                    g2.setPaint(this.getSeriesPaint(series));
                    g2.draw(s.seriesPath);
                }
            } else if (item != 0 && itemVisible) {
                double x0 = dataset.getXValue(series, item - 1);
                double y0 = dataset.getYValue(series, item - 1);
                if (!Double.isNaN(x0) && !Double.isNaN(y0)) {
                    boolean drawLine = true;
                    if (this.getPlotDiscontinuous()) {
                        int numX = dataset.getItemCount(series);
                        double minX = dataset.getXValue(series, 0);
                        double maxX = dataset.getXValue(series, numX - 1);
                        if (this.getGapThresholdType() == UnitType.ABSOLUTE) {
                            drawLine = Math.abs(x1 - x0) <= this.getGapThreshold();
                        } else {
                            boolean bl = drawLine = Math.abs(x1 - x0) <= (maxX - minX) / (double)numX * this.getGapThreshold();
                        }
                    }
                    if (drawLine) {
                        double transX0 = domainAxis.valueToJava2D(x0, dataArea, xAxisLocation);
                        double transY0 = rangeAxis.valueToJava2D(y0, dataArea, yAxisLocation);
                        if (Double.isNaN(transX0) || Double.isNaN(transY0) || Double.isNaN(transX1) || Double.isNaN(transY1)) {
                            return;
                        }
                        if (orientation == PlotOrientation.HORIZONTAL) {
                            state.workingLine.setLine(transY0, transX0, transY1, transX1);
                        } else if (orientation == PlotOrientation.VERTICAL) {
                            state.workingLine.setLine(transX0, transY0, transX1, transY1);
                        }
                        if (state.workingLine.intersects(dataArea)) {
                            g2.draw(state.workingLine);
                        }
                    }
                }
            }
        }
        if (!itemVisible) {
            return;
        }
        if (this.getBaseShapesVisible()) {
            Shape shape = this.getItemShape(series, item);
            if (orientation == PlotOrientation.HORIZONTAL) {
                shape = ShapeUtilities.createTranslatedShape(shape, transY1, transX1);
            } else if (orientation == PlotOrientation.VERTICAL) {
                shape = ShapeUtilities.createTranslatedShape(shape, transX1, transY1);
            }
            if (shape.intersects(dataArea)) {
                Rectangle rect;
                if (this.getItemShapeFilled(series, item)) {
                    g2.fill(shape);
                } else {
                    g2.draw(shape);
                }
                Scatterplot.DataItem2D dataItem = this.getItem(item, series);
                boolean selected = false;
                for (Scatterplot.DataItem2D selectedItem : this.selectedItems) {
                    if (!selectedItem.equals(dataItem)) continue;
                    selected = true;
                    break;
                }
                if (selected) {
                    rect = shape.getBounds();
                    rect.grow(2, 2);
                    g2.draw(rect);
                }
                rect = new Rectangle();
                rect.setSize(shape.getBounds().getSize());
                rect.setLocation(this.chartPanel.translateJava2DToScreen(shape.getBounds().getLocation()));
                dataItem.setBounds(rect);
            }
            entityArea = shape;
        }
        if (this.getPlotImages() && (image = this.getImage(plot, series, item, transX1, transY1)) != null) {
            Point hotspot = this.getImageHotspot(plot, series, item, transX1, transY1, image);
            g2.drawImage(image, (int)(transX1 - hotspot.getX()), (int)(transY1 - hotspot.getY()), null);
            entityArea = new Rectangle2D.Double(transX1 - hotspot.getX(), transY1 - hotspot.getY(), image.getWidth(null), image.getHeight(null));
        }
        if (this.isItemLabelVisible(series, item)) {
            double xx = transX1;
            double yy = transY1;
            if (orientation == PlotOrientation.HORIZONTAL) {
                xx = transY1;
                yy = transX1;
            }
            this.drawItemLabel(g2, orientation, dataset, series, item, xx, yy, y1 < 0.0);
        }
        if (entities != null) {
            this.addEntity(entities, entityArea, dataset, series, item, transX1, transY1);
        }
    }

    private Scatterplot.DataItem2D getItem(int seriesIndex, int series) {
        for (Scatterplot.DataItem2D item : this.allItems) {
            if (item.getSeriesIndex() != seriesIndex || item.getSeries() != series) continue;
            return item;
        }
        throw new IllegalArgumentException("illegal plot item: seriesIndex " + seriesIndex + ", series " + series);
    }
}

