/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.net.URI;
import java.util.Arrays;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.CombinationTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.util.MessageIdList;
import org.apache.activemq.xbean.XBeanBrokerFactory;

public class TwoBrokerMulticastQueueTest
extends CombinationTestSupport {
    public static final int MESSAGE_COUNT = 100;
    public static final int BROKER_COUNT = 2;
    public static final int CONSUMER_COUNT = 20;
    public String sendUri;
    public String recvUri;
    private BrokerService[] brokers;

    public static Test suite() {
        return TwoBrokerMulticastQueueTest.suite(TwoBrokerMulticastQueueTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TwoBrokerMulticastQueueTest.suite());
    }

    public void setUp() throws Exception {
        super.setAutoFail(true);
        super.setUp();
    }

    public void tearDown() throws Exception {
        if (this.brokers != null) {
            for (int i = 0; i < 2; ++i) {
                if (this.brokers[i] == null) continue;
                this.brokers[i].stop();
            }
            super.tearDown();
        }
    }

    private void doSendReceiveTest() throws Exception {
        ActiveMQQueue dest = new ActiveMQQueue("TEST.FOO");
        ConnectionFactory sendFactory = this.createConnectionFactory(this.sendUri);
        Connection conn = this.createConnection(sendFactory);
        this.sendMessages(conn, (Destination)dest, 100);
        Thread.sleep(500L);
        ConnectionFactory recvFactory = this.createConnectionFactory(this.recvUri);
        TwoBrokerMulticastQueueTest.assertEquals((int)100, (int)this.receiveMessages(this.createConnection(recvFactory), (Destination)dest, 0));
    }

    private void doMultipleConsumersConnectTest() throws Exception {
        ActiveMQQueue dest = new ActiveMQQueue("TEST.FOO");
        ConnectionFactory sendFactory = this.createConnectionFactory(this.sendUri);
        Connection conn = this.createConnection(sendFactory);
        this.sendMessages(conn, (Destination)dest, 100);
        Thread.sleep(500L);
        ConnectionFactory recvFactory = this.createConnectionFactory(this.recvUri);
        TwoBrokerMulticastQueueTest.assertEquals((int)100, (int)this.receiveMessages(this.createConnection(recvFactory), (Destination)dest, 0));
        for (int i = 0; i < 19; ++i) {
            TwoBrokerMulticastQueueTest.assertEquals((int)0, (int)this.receiveMessages(this.createConnection(recvFactory), (Destination)dest, 200));
        }
    }

    public void initCombosForTestSendReceive() {
        this.addCombinationValues("sendUri", new Object[]{"tcp://localhost:61616", "tcp://localhost:61617"});
        this.addCombinationValues("recvUri", new Object[]{"tcp://localhost:61616", "tcp://localhost:61617"});
    }

    public void testSendReceive() throws Exception {
        this.createMulticastBrokerNetwork();
        this.doSendReceiveTest();
    }

    public void initCombosForTestMultipleConsumersConnect() {
        this.addCombinationValues("sendUri", new Object[]{"tcp://localhost:61616", "tcp://localhost:61617"});
        this.addCombinationValues("recvUri", new Object[]{"tcp://localhost:61616", "tcp://localhost:61617"});
    }

    public void testMultipleConsumersConnect() throws Exception {
        this.createMulticastBrokerNetwork();
        this.doMultipleConsumersConnectTest();
    }

    public void testSendReceiveUsingFailover() throws Exception {
        this.sendUri = "failover:(tcp://localhost:61616,tcp://localhost:61617)";
        this.recvUri = "failover:(tcp://localhost:61616,tcp://localhost:61617)";
        this.createMulticastBrokerNetwork();
        this.doSendReceiveTest();
    }

    public void testMultipleConsumersConnectUsingFailover() throws Exception {
        this.sendUri = "failover:(tcp://localhost:61616,tcp://localhost:61617)";
        this.recvUri = "failover:(tcp://localhost:61616,tcp://localhost:61617)";
        this.createMulticastBrokerNetwork();
        this.doMultipleConsumersConnectTest();
    }

    public void testSendReceiveUsingDiscovery() throws Exception {
        this.sendUri = "discovery:multicast://default";
        this.recvUri = "discovery:multicast://default";
        this.createMulticastBrokerNetwork();
        this.doSendReceiveTest();
    }

    public void testMultipleConsumersConnectUsingDiscovery() throws Exception {
        this.sendUri = "discovery:multicast://default";
        this.recvUri = "discovery:multicast://default";
        this.createMulticastBrokerNetwork();
        this.doMultipleConsumersConnectTest();
    }

    public void testSendReceiveUsingAutoAssignFailover() throws Exception {
        this.sendUri = "failover:(discovery:multicast://default)";
        this.recvUri = "failover:(discovery:multicast://default)";
        this.createAutoAssignMulticastBrokerNetwork();
        this.doSendReceiveTest();
    }

    public void testMultipleConsumersConnectUsingAutoAssignFailover() throws Exception {
        this.sendUri = "failover:(discovery:multicast://default)";
        this.recvUri = "failover:(discovery:multicast://default)";
        this.createAutoAssignMulticastBrokerNetwork();
        this.doMultipleConsumersConnectTest();
    }

    public void testSendReceiveUsingAutoAssignDiscovery() throws Exception {
        this.sendUri = "discovery:multicast://default";
        this.recvUri = "discovery:multicast://default";
        this.createAutoAssignMulticastBrokerNetwork();
        this.doSendReceiveTest();
    }

    public void testMultipleConsumersConnectUsingAutoAssignDiscovery() throws Exception {
        this.sendUri = "discovery:multicast://default";
        this.recvUri = "discovery:multicast://default";
        this.createAutoAssignMulticastBrokerNetwork();
        this.doMultipleConsumersConnectTest();
    }

    protected void createMulticastBrokerNetwork() throws Exception {
        this.brokers = new BrokerService[2];
        for (int i = 0; i < 2; ++i) {
            this.brokers[i] = this.createBroker("org/apache/activemq/usecases/multicast-broker-" + (i + 1) + ".xml");
            this.brokers[i].start();
        }
        Thread.sleep(1000L);
    }

    protected void createAutoAssignMulticastBrokerNetwork() throws Exception {
        this.brokers = new BrokerService[2];
        for (int i = 0; i < 2; ++i) {
            this.brokers[i] = this.createBroker("org/apache/activemq/usecases/multicast-broker-auto.xml");
            this.brokers[i].start();
        }
        Thread.sleep(1000L);
    }

    protected BrokerService createBroker(String uri) throws Exception {
        return new XBeanBrokerFactory().createBroker(new URI(uri));
    }

    protected ConnectionFactory createConnectionFactory(String uri) {
        return new ActiveMQConnectionFactory(uri);
    }

    protected Connection createConnection(ConnectionFactory factory) throws JMSException {
        Connection conn = factory.createConnection();
        return conn;
    }

    protected int receiveMessages(Connection conn, Destination dest, int waitTime) throws JMSException, InterruptedException {
        conn.start();
        MessageIdList list = new MessageIdList();
        Session sess = conn.createSession(false, 1);
        MessageConsumer consumer = sess.createConsumer(dest);
        consumer.setMessageListener((MessageListener)list);
        if (waitTime > 0) {
            Thread.sleep(waitTime);
        } else {
            list.waitForMessagesToArrive(100);
        }
        conn.close();
        return list.getMessageCount();
    }

    protected void sendMessages(Connection conn, Destination dest, int count) throws JMSException {
        conn.start();
        Session sess = conn.createSession(false, 1);
        MessageProducer prod = sess.createProducer(dest);
        for (int i = 0; i < count; ++i) {
            prod.send((Message)this.createTextMessage(sess, "Message " + i, 1024));
        }
        conn.close();
    }

    protected TextMessage createTextMessage(Session session, String initText, int messageSize) throws JMSException {
        TextMessage msg = session.createTextMessage();
        if (initText.length() < messageSize) {
            char[] data = new char[messageSize - initText.length()];
            Arrays.fill(data, '*');
            String str = new String(data);
            msg.setText(initText + str);
        } else {
            msg.setText(initText);
        }
        return msg;
    }
}

