/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.broker.BrokerService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueueWorkerPrefetchTest
extends TestCase
implements MessageListener {
    private static final Log LOG = LogFactory.getLog(QueueWorkerPrefetchTest.class);
    private static final int BATCH_SIZE = 10;
    private static final long WAIT_TIMEOUT = 10000L;
    private static final String CONNECTION_URL = "tcp://localhost:61616";
    private static final int QUEUE_PREFETCH_SIZE = 1;
    private static final int NUM_WORKERS = 2;
    private BrokerService broker;
    private MessageProducer workItemProducer;
    private MessageConsumer masterItemConsumer;
    private AtomicLong acksReceived = new AtomicLong(0L);
    private AtomicReference<CountDownLatch> latch = new AtomicReference();

    public void onMessage(Message message) {
        long acks = this.acksReceived.incrementAndGet();
        this.latch.get().countDown();
        if (acks % 1L == 0L) {
            LOG.info((Object)("Master now has ack count of: " + this.acksReceived));
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.broker = new BrokerService();
        this.broker.setPersistent(false);
        this.broker.setUseJmx(true);
        this.broker.addConnector(CONNECTION_URL);
        this.broker.start();
    }

    protected void tearDown() throws Exception {
        this.broker.deleteAllMessages();
        this.broker.stop();
        super.tearDown();
    }

    public void testActiveMQ() throws Exception {
        int i;
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(CONNECTION_URL);
        ActiveMQPrefetchPolicy prefetchPolicy = new ActiveMQPrefetchPolicy();
        prefetchPolicy.setQueuePrefetch(1);
        connectionFactory.setPrefetchPolicy(prefetchPolicy);
        Connection connection = connectionFactory.createConnection();
        connection.start();
        Session masterSession = connection.createSession(false, 1);
        this.workItemProducer = masterSession.createProducer((Destination)masterSession.createQueue("work-item"));
        this.masterItemConsumer = masterSession.createConsumer((Destination)masterSession.createQueue("master-item"));
        this.masterItemConsumer.setMessageListener((MessageListener)this);
        Worker[] workers = new Worker[2];
        for (i = 0; i < 2; ++i) {
            workers[i] = new Worker(connection.createSession(false, 1));
        }
        this.acksReceived.set(0L);
        this.latch.set(new CountDownLatch(10));
        this.workItemProducer.send((Message)masterSession.createObjectMessage((Serializable)new WorkMessage(1)));
        if (!this.latch.get().await(10000L, TimeUnit.MILLISECONDS)) {
            QueueWorkerPrefetchTest.fail((String)("First batch only received " + this.acksReceived + " messages"));
        }
        LOG.info((Object)"First batch received");
        this.acksReceived.set(0L);
        this.latch.set(new CountDownLatch(10));
        this.workItemProducer.send((Message)masterSession.createObjectMessage((Serializable)new WorkMessage(1)));
        if (!this.latch.get().await(10000L, TimeUnit.MILLISECONDS)) {
            QueueWorkerPrefetchTest.fail((String)("Second batch only received " + this.acksReceived + " messages"));
        }
        LOG.info((Object)"Second batch received");
        for (i = 0; i < 2; ++i) {
            workers[i].close();
        }
        masterSession.close();
        connection.close();
    }

    private static class Worker
    implements MessageListener {
        private static AtomicInteger counter = new AtomicInteger(0);
        private Session session;
        private MessageProducer masterItemProducer;
        private MessageProducer workItemProducer;

        public Worker(Session session) throws JMSException {
            this.session = session;
            this.masterItemProducer = session.createProducer((Destination)session.createQueue("master-item"));
            Queue workItemQueue = session.createQueue("work-item");
            this.workItemProducer = session.createProducer((Destination)workItemQueue);
            MessageConsumer workItemConsumer = session.createConsumer((Destination)workItemQueue);
            workItemConsumer.setMessageListener((MessageListener)this);
        }

        public void onMessage(Message message) {
            try {
                WorkMessage work = (WorkMessage)((ObjectMessage)message).getObject();
                long c = counter.incrementAndGet();
                if (c % 10L != 0L) {
                    this.workItemProducer.send((Message)this.session.createObjectMessage((Serializable)new WorkMessage(work.id + 1)));
                }
                this.masterItemProducer.send((Message)this.session.createObjectMessage((Serializable)work));
            }
            catch (JMSException e) {
                throw new IllegalStateException("Something has gone wrong", e);
            }
        }

        public void close() throws JMSException {
            this.masterItemProducer.close();
            this.workItemProducer.close();
            this.session.close();
        }
    }

    private static class WorkMessage
    implements Serializable {
        private final int id;

        public WorkMessage(int id) {
            this.id = id;
        }

        public String toString() {
            return "Work: " + this.id;
        }
    }
}

