/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.memory.buffer;

import junit.framework.TestCase;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.memory.buffer.DummyMessage;
import org.apache.activemq.memory.buffer.MessageBuffer;
import org.apache.activemq.memory.buffer.MessageQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class MemoryBufferTestSupport
extends TestCase {
    private static final Log LOG = LogFactory.getLog(MemoryBufferTestSupport.class);
    protected MessageBuffer buffer = this.createMessageBuffer();
    protected MessageQueue qA = this.buffer.createMessageQueue();
    protected MessageQueue qB = this.buffer.createMessageQueue();
    protected MessageQueue qC = this.buffer.createMessageQueue();
    protected int messageCount;

    protected abstract MessageBuffer createMessageBuffer();

    protected void setUp() throws Exception {
        this.buffer = this.createMessageBuffer();
        this.qA = this.buffer.createMessageQueue();
        this.qB = this.buffer.createMessageQueue();
        this.qC = this.buffer.createMessageQueue();
    }

    protected void dump() {
        LOG.info("Dumping current state");
        this.dumpQueue(this.qA, "A");
        this.dumpQueue(this.qB, "B");
        this.dumpQueue(this.qC, "C");
    }

    protected void dumpQueue(MessageQueue queue, String name) {
        LOG.info("  " + name + " = " + queue.getList());
    }

    protected ActiveMQMessage createMessage(int size) throws Exception {
        DummyMessage answer = new DummyMessage(size);
        answer.setIntProperty("counter", ++this.messageCount);
        answer.setJMSMessageID("" + this.messageCount);
        return answer;
    }
}

