/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.group;

import junit.framework.TestCase;
import org.apache.activemq.broker.region.group.MessageGroupMap;
import org.apache.activemq.broker.region.group.MessageGroupSet;
import org.apache.activemq.broker.region.group.SimpleMessageGroupMap;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.SessionId;

public class MessageGroupMapTest
extends TestCase {
    protected MessageGroupMap map;
    private ConsumerId consumer1;
    private ConsumerId consumer2;
    private ConsumerId consumer3;
    private long idCounter;

    public void testSingleConsumerForManyBucks() throws Exception {
        this.assertGet("1", null);
        this.map.put("1", this.consumer1);
        this.assertGet("1", this.consumer1);
        this.map.put("2", this.consumer1);
        this.assertGet("2", this.consumer1);
        this.map.put("3", this.consumer1);
        this.assertGet("3", this.consumer1);
        MessageGroupSet set = this.map.removeConsumer(this.consumer1);
        this.assertContains(set, "1");
        this.assertContains(set, "2");
        this.assertContains(set, "3");
        this.assertGet("1", null);
        this.assertGet("2", null);
        this.assertGet("3", null);
    }

    public void testManyConsumers() throws Exception {
        this.assertGet("1", null);
        this.map.put("1", this.consumer1);
        this.assertGet("1", this.consumer1);
        this.map.put("2", this.consumer2);
        this.assertGet("2", this.consumer2);
        this.map.put("3", this.consumer3);
        this.assertGet("3", this.consumer3);
        MessageGroupSet set = this.map.removeConsumer(this.consumer1);
        this.assertContains(set, "1");
        this.assertGet("1", null);
        this.map.put("1", this.consumer2);
        this.assertGet("1", this.consumer2);
        set = this.map.removeConsumer(this.consumer2);
        this.assertContains(set, "1");
        this.assertContains(set, "2");
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.map = this.createMessageGroupMap();
        this.consumer1 = this.createConsumerId();
        this.consumer2 = this.createConsumerId();
        this.consumer3 = this.createConsumerId();
    }

    protected MessageGroupMap createMessageGroupMap() {
        return new SimpleMessageGroupMap();
    }

    protected ConsumerId createConsumerId() {
        ConnectionId connectionId = new ConnectionId("" + ++this.idCounter);
        SessionId sessionId = new SessionId(connectionId, ++this.idCounter);
        ConsumerId answer = new ConsumerId(sessionId, ++this.idCounter);
        return answer;
    }

    protected void assertGet(String groupdId, ConsumerId expected) {
        ConsumerId actual = this.map.get(groupdId);
        MessageGroupMapTest.assertEquals((String)("Entry for groupId: " + groupdId), (Object)expected, (Object)actual);
    }

    protected void assertContains(MessageGroupSet set, String groupID) {
        MessageGroupMapTest.assertTrue((String)("MessageGroup set: " + set + " does not contain groupID: " + groupID), (boolean)set.contains(groupID));
    }
}

