/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.TestNGException;
import org.testng.internal.BaseTestMethod;
import org.testng.internal.NoOpTestClass;
import org.testng.internal.Parameters;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.xml.XmlTest;

public class FactoryMethod
extends BaseTestMethod {
    private Object m_instance = null;
    private XmlTest m_xmlTest = null;
    private ITestContext m_testContext = null;

    public FactoryMethod(Method method, Object instance, XmlTest xmlTest, IAnnotationFinder annotationFinder, ITestContext testContext) {
        super(method, annotationFinder);
        if (!instance.getClass().isAssignableFrom(method.getDeclaringClass())) {
            throw new TestNGException("Mismatch between instance/method classes:" + instance.getClass() + " " + method.getDeclaringClass());
        }
        this.m_instance = instance;
        this.m_xmlTest = xmlTest;
        this.m_testContext = testContext;
        NoOpTestClass tc = new NoOpTestClass();
        tc.setTestClass(method.getDeclaringClass());
        this.m_testClass = tc;
    }

    private static void ppp(String s) {
        System.out.println("[FactoryMethod] " + s);
    }

    public Object[] invoke() {
        ArrayList<Object> result = new ArrayList<Object>();
        HashMap<String, String> allParameterNames = new HashMap<String, String>();
        Iterator<Object[]> parameterIterator = Parameters.handleParameters(this, allParameterNames, this.m_instance, new Parameters.MethodParameters(this.m_xmlTest.getParameters(), null, this.m_testContext), this.m_xmlTest.getSuite(), this.m_annotationFinder);
        try {
            while (parameterIterator.hasNext()) {
                Object[] testInstances;
                Object[] parameters = parameterIterator.next();
                for (Object testInstance : testInstances = (Object[])this.getMethod().invoke(this.m_instance, parameters)) {
                    result.add(testInstance);
                }
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return result.toArray(new Object[result.size()]);
    }

    public ITestNGMethod clone() {
        throw new IllegalStateException("clone is not supported for FactoryMethod");
    }
}

