package org.jfree.chart.entity.junit;

import java.awt.geom.Area;
import java.awt.Shape;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.entity.SOMItemEntity;
import org.jfree.data.som.SOMDataset;

/**
 * Tests for the {@link org.jfree.chart.entity.SOMItemEntity} class.
 */
public class SOMItemEntityTests extends TestCase {

    private SOMDataset dataset;

    /**
     * Returns the tests as a test suite.
     *
     * @return The test suite.
     */
    public static Test suite() {
        return new TestSuite(SOMItemEntityTests.class);
    }

    /**
     * Constructs a new set of tests.
     *
     * @param name  the name of the tests.
     */
    public SOMItemEntityTests(String name) {
        super(name);
    }


   /**
    * Does the tests.
    */ 
   public void testEntity(){

	dataset = new SOMDataset(3,3);

	SOMItemEntity item = new SOMItemEntity(new Area(), dataset, 1, 2, "tooltip", "url");

	assertEquals(item.getX(),1);
	assertEquals(item.getY(),2);

	assertTrue(item.getDataset().equals(dataset));

	SOMDataset data = new SOMDataset(2,2);

	try {
		item.setDataset(data);
	} catch (Exception e){
		;
	}


	try {
		assertEquals(item.getDataset(), data);
	} catch (Exception e){
		;
	}


	try {
		assertFalse(item.getDataset().equals(dataset));
	} catch (Exception e) {
		;
	}
   }

   /**
    * Tests for wrong values
    */
   public void testWrong(){

	dataset = new SOMDataset(3, 3);
	SOMItemEntity item = new SOMItemEntity(new Area(), dataset, 1, 2, "tooltip", "url");

	// null dataset
	try{
	  item = new SOMItemEntity(new Area(), null, 1, 2, "tooltip", "url");
	  assertTrue(false);
	} catch (IllegalArgumentException e){
	  assertTrue(e.getMessage().equals("dataset was null"));
	}

	// null area
	try {
	  item = new SOMItemEntity(null, dataset, 1, 2, "tooltip", "url");
	  assertTrue(false);
	} catch (Exception e){
	  ;
	}

	// integer max and min
	try {
	  item = new SOMItemEntity(new Area(), dataset, 
					Integer.MAX_VALUE, 
					Integer.MIN_VALUE, 
					"tooltip", "url");
	  assertTrue(false);
	} catch (IllegalArgumentException e){
		assertTrue(e.getMessage().equals("y was negative"));
	}

	try {
	  item = new SOMItemEntity(new Area(), dataset, 
					Integer.MIN_VALUE, 
					Integer.MAX_VALUE, 
					"tooltip", "url");
	  assertTrue(false);
	} catch (IllegalArgumentException e){
		assertTrue(e.getMessage().equals("x was negative"));
	}

   }

}
