/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadaptor;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.command.XATransactionId;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.store.ProxyMessageStore;
import org.apache.activemq.store.ProxyTopicMessageStore;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.store.TransactionRecoveryListener;
import org.apache.activemq.store.TransactionStore;
import org.apache.activemq.store.kahadaptor.KahaMessageStore;
import org.apache.activemq.store.kahadaptor.KahaPersistenceAdapter;
import org.apache.activemq.store.kahadaptor.KahaTransaction;

public class KahaTransactionStore
implements TransactionStore {
    private Map transactions = new ConcurrentHashMap();
    private Map prepared;
    private KahaPersistenceAdapter adaptor;

    KahaTransactionStore(KahaPersistenceAdapter adaptor, Map preparedMap) {
        this.adaptor = adaptor;
        this.prepared = preparedMap;
    }

    public MessageStore proxy(MessageStore messageStore) {
        return new ProxyMessageStore(messageStore){

            public void addMessage(ConnectionContext context, Message send) throws IOException {
                KahaTransactionStore.this.addMessage(this.getDelegate(), send);
            }

            public void removeMessage(ConnectionContext context, MessageAck ack) throws IOException {
                KahaTransactionStore.this.removeMessage(this.getDelegate(), ack);
            }
        };
    }

    public TopicMessageStore proxy(TopicMessageStore messageStore) {
        return new ProxyTopicMessageStore(messageStore){

            public void addMessage(ConnectionContext context, Message send) throws IOException {
                KahaTransactionStore.this.addMessage(this.getDelegate(), send);
            }

            public void removeMessage(ConnectionContext context, MessageAck ack) throws IOException {
                KahaTransactionStore.this.removeMessage(this.getDelegate(), ack);
            }
        };
    }

    public void prepare(TransactionId txid) {
        KahaTransaction tx = this.getTx(txid);
        if (tx != null) {
            tx.prepare();
            this.prepared.put(txid, tx);
        }
    }

    public void commit(TransactionId txid, boolean wasPrepared) throws IOException {
        KahaTransaction tx = this.getTx(txid);
        if (tx != null) {
            tx.commit(this);
            this.removeTx(txid);
        }
    }

    public void rollback(TransactionId txid) {
        KahaTransaction tx = this.getTx(txid);
        if (tx != null) {
            tx.rollback();
            this.removeTx(txid);
        }
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public synchronized void recover(TransactionRecoveryListener listener) throws IOException {
        for (Map.Entry entry : this.prepared.entrySet()) {
            XATransactionId xid = (XATransactionId)entry.getKey();
            KahaTransaction kt = (KahaTransaction)entry.getValue();
            listener.recover(xid, kt.getMessages(), kt.getAcks());
        }
    }

    void addMessage(MessageStore destination, Message message) throws IOException {
        if (message.isInTransaction()) {
            KahaTransaction tx = this.getOrCreateTx(message.getTransactionId());
            tx.add((KahaMessageStore)destination, message);
        } else {
            destination.addMessage(null, message);
        }
    }

    final void removeMessage(MessageStore destination, MessageAck ack) throws IOException {
        if (ack.isInTransaction()) {
            KahaTransaction tx = this.getOrCreateTx(ack.getTransactionId());
            tx.add((KahaMessageStore)destination, ack);
        } else {
            destination.removeMessage(null, ack);
        }
    }

    protected synchronized KahaTransaction getTx(TransactionId key) {
        KahaTransaction result = (KahaTransaction)this.transactions.get(key);
        if (result == null) {
            result = (KahaTransaction)this.prepared.get(key);
        }
        return result;
    }

    protected synchronized KahaTransaction getOrCreateTx(TransactionId key) {
        KahaTransaction result = (KahaTransaction)this.transactions.get(key);
        if (result == null) {
            result = new KahaTransaction();
            this.transactions.put(key, result);
        }
        return result;
    }

    protected synchronized void removeTx(TransactionId key) {
        this.transactions.remove(key);
        this.prepared.remove(key);
    }

    public void delete() {
        this.transactions.clear();
        this.prepared.clear();
    }

    protected MessageStore getStoreById(Object id) {
        return this.adaptor.retrieveMessageStore(id);
    }
}

