/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.IOException;
import javax.jms.JMSException;
import org.apache.activemq.command.Command;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFilter;
import org.apache.activemq.transport.stomp.FrameTranslator;
import org.apache.activemq.transport.stomp.ProtocolConverter;
import org.apache.activemq.transport.stomp.StompFrame;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StompTransportFilter
extends TransportFilter {
    private static final Log LOG = LogFactory.getLog(StompTransportFilter.class);
    private final ProtocolConverter protocolConverter;
    private final Object sendToActiveMQMutex = new Object();
    private final Object sendToStompMutex = new Object();
    private final FrameTranslator frameTranslator;
    private boolean trace;

    public StompTransportFilter(Transport next, FrameTranslator translator) {
        super(next);
        this.frameTranslator = translator;
        this.protocolConverter = new ProtocolConverter(this, translator);
    }

    public void oneway(Object o) throws IOException {
        try {
            Command command = (Command)o;
            this.protocolConverter.onActiveMQCommad(command);
        }
        catch (JMSException e) {
            throw IOExceptionSupport.create(e);
        }
    }

    public void onCommand(Object command) {
        try {
            if (this.trace) {
                LOG.trace("Received: \n" + command);
            }
            this.protocolConverter.onStompCommad((StompFrame)command);
        }
        catch (IOException e) {
            this.onException(e);
        }
        catch (JMSException e) {
            this.onException(IOExceptionSupport.create(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendToActiveMQ(Command command) {
        Object object = this.sendToActiveMQMutex;
        synchronized (object) {
            this.transportListener.onCommand(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendToStomp(StompFrame command) throws IOException {
        if (this.trace) {
            LOG.trace("Sending: \n" + command);
        }
        Object object = this.sendToStompMutex;
        synchronized (object) {
            this.next.oneway(command);
        }
    }

    public FrameTranslator getFrameTranslator() {
        return this.frameTranslator;
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }
}

