/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadaptor;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.kaha.CommandMarshaller;
import org.apache.activemq.kaha.ContainerId;
import org.apache.activemq.kaha.ListContainer;
import org.apache.activemq.kaha.MapContainer;
import org.apache.activemq.kaha.Marshaller;
import org.apache.activemq.kaha.MessageIdMarshaller;
import org.apache.activemq.kaha.MessageMarshaller;
import org.apache.activemq.kaha.Store;
import org.apache.activemq.kaha.StoreFactory;
import org.apache.activemq.kaha.impl.StoreLockedExcpetion;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.store.TransactionStore;
import org.apache.activemq.store.kahadaptor.KahaMessageStore;
import org.apache.activemq.store.kahadaptor.KahaTopicMessageStore;
import org.apache.activemq.store.kahadaptor.KahaTransactionStore;
import org.apache.activemq.store.kahadaptor.TopicSubAck;
import org.apache.activemq.store.kahadaptor.TopicSubAckMarshaller;
import org.apache.activemq.store.kahadaptor.TransactionMarshaller;
import org.apache.activemq.usage.SystemUsage;
import org.apache.activemq.util.IOHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KahaPersistenceAdapter
implements PersistenceAdapter {
    private static final int STORE_LOCKED_WAIT_DELAY = 10000;
    private static final Log LOG = LogFactory.getLog(KahaPersistenceAdapter.class);
    private static final String PREPARED_TRANSACTIONS_NAME = "PreparedTransactions";
    protected OpenWireFormat wireFormat = new OpenWireFormat();
    protected KahaTransactionStore transactionStore;
    protected ConcurrentHashMap<ActiveMQTopic, TopicMessageStore> topics = new ConcurrentHashMap();
    protected ConcurrentHashMap<ActiveMQQueue, MessageStore> queues = new ConcurrentHashMap();
    protected ConcurrentHashMap<ActiveMQDestination, MessageStore> messageStores = new ConcurrentHashMap();
    private long maxDataFileLength = 0x2000000L;
    private File directory;
    private String brokerName;
    private Store theStore;
    private boolean initialized;
    private final AtomicLong storeSize;
    private boolean persistentIndex = true;

    public KahaPersistenceAdapter(AtomicLong size) {
        this.storeSize = size;
    }

    public KahaPersistenceAdapter() {
        this(new AtomicLong());
    }

    @Override
    public Set<ActiveMQDestination> getDestinations() {
        HashSet<ActiveMQDestination> rc = new HashSet<ActiveMQDestination>();
        try {
            Store store = this.getStore();
            for (ContainerId id : store.getMapContainerIds()) {
                Object obj = id.getKey();
                if (!(obj instanceof ActiveMQDestination)) continue;
                rc.add((ActiveMQDestination)obj);
            }
        }
        catch (IOException e) {
            LOG.error("Failed to get destinations ", e);
        }
        return rc;
    }

    @Override
    public synchronized MessageStore createQueueMessageStore(ActiveMQQueue destination) throws IOException {
        MessageStore rc = this.queues.get(destination);
        if (rc == null) {
            rc = new KahaMessageStore(this.getMapContainer(destination, "queue-data"), destination);
            this.messageStores.put(destination, rc);
            if (this.transactionStore != null) {
                rc = this.transactionStore.proxy(rc);
            }
            this.queues.put(destination, rc);
        }
        return rc;
    }

    @Override
    public synchronized TopicMessageStore createTopicMessageStore(ActiveMQTopic destination) throws IOException {
        TopicMessageStore rc = this.topics.get(destination);
        if (rc == null) {
            Store store = this.getStore();
            MapContainer<MessageId, Message> messageContainer = this.getMapContainer(destination, "topic-data");
            MapContainer subsContainer = this.getSubsMapContainer(destination.toString() + "-Subscriptions", "topic-subs");
            ListContainer ackContainer = store.getListContainer(destination.toString(), "topic-acks");
            ackContainer.setMarshaller(new TopicSubAckMarshaller());
            rc = new KahaTopicMessageStore(store, messageContainer, ackContainer, subsContainer, destination);
            this.messageStores.put(destination, rc);
            if (this.transactionStore != null) {
                rc = this.transactionStore.proxy(rc);
            }
            this.topics.put(destination, rc);
        }
        return rc;
    }

    protected MessageStore retrieveMessageStore(Object id) {
        MessageStore result = this.messageStores.get(id);
        return result;
    }

    @Override
    public TransactionStore createTransactionStore() throws IOException {
        if (this.transactionStore == null) {
            while (true) {
                try {
                    Store store = this.getStore();
                    MapContainer container = store.getMapContainer(PREPARED_TRANSACTIONS_NAME, "transactions");
                    container.setKeyMarshaller(new CommandMarshaller(this.wireFormat));
                    container.setValueMarshaller(new TransactionMarshaller(this.wireFormat));
                    container.load();
                    this.transactionStore = new KahaTransactionStore(this, container);
                }
                catch (StoreLockedExcpetion e) {
                    LOG.info("Store is locked... waiting 10 seconds for the Store to be unlocked.");
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                break;
            }
        }
        return this.transactionStore;
    }

    @Override
    public void beginTransaction(ConnectionContext context) {
    }

    @Override
    public void commitTransaction(ConnectionContext context) throws IOException {
        if (this.theStore != null) {
            this.theStore.force();
        }
    }

    @Override
    public void rollbackTransaction(ConnectionContext context) {
    }

    @Override
    public void start() throws Exception {
        this.initialize();
    }

    @Override
    public void stop() throws Exception {
        if (this.theStore != null) {
            this.theStore.close();
        }
    }

    @Override
    public long getLastMessageBrokerSequenceId() throws IOException {
        return 0L;
    }

    @Override
    public void deleteAllMessages() throws IOException {
        if (this.theStore != null) {
            if (this.theStore.isInitialized()) {
                this.theStore.clear();
            } else {
                this.theStore.delete();
            }
        } else {
            StoreFactory.delete(this.getStoreDirectory());
        }
    }

    protected MapContainer<MessageId, Message> getMapContainer(Object id, String containerName) throws IOException {
        Store store = this.getStore();
        MapContainer container = store.getMapContainer(id, containerName);
        container.setKeyMarshaller(new MessageIdMarshaller());
        container.setValueMarshaller(new MessageMarshaller(this.wireFormat));
        container.load();
        return container;
    }

    protected MapContainer getSubsMapContainer(Object id, String containerName) throws IOException {
        Store store = this.getStore();
        MapContainer container = store.getMapContainer(id, containerName);
        container.setKeyMarshaller(Store.STRING_MARSHALLER);
        container.setValueMarshaller(this.createMessageMarshaller());
        container.load();
        return container;
    }

    protected Marshaller<Object> createMessageMarshaller() {
        return new CommandMarshaller(this.wireFormat);
    }

    protected ListContainer<TopicSubAck> getListContainer(Object id, String containerName) throws IOException {
        Store store = this.getStore();
        ListContainer container = store.getListContainer(id, containerName);
        container.setMarshaller(this.createMessageMarshaller());
        container.load();
        return container;
    }

    @Override
    public void setUsageManager(SystemUsage usageManager) {
    }

    public long getMaxDataFileLength() {
        return this.maxDataFileLength;
    }

    public boolean isPersistentIndex() {
        return this.persistentIndex;
    }

    public void setPersistentIndex(boolean persistentIndex) {
        this.persistentIndex = persistentIndex;
    }

    public void setMaxDataFileLength(long maxDataFileLength) {
        this.maxDataFileLength = maxDataFileLength;
    }

    protected final synchronized Store getStore() throws IOException {
        if (this.theStore == null) {
            this.theStore = this.createStore();
        }
        return this.theStore;
    }

    protected final Store createStore() throws IOException {
        Store result = StoreFactory.open(this.getStoreDirectory(), "rw", this.storeSize);
        result.setMaxDataFileLength(this.maxDataFileLength);
        result.setPersistentIndex(this.isPersistentIndex());
        result.setDefaultContainerName("container-roots");
        return result;
    }

    private String getStoreName() {
        this.initialize();
        return this.directory.getAbsolutePath();
    }

    private File getStoreDirectory() {
        this.initialize();
        return this.directory;
    }

    public String toString() {
        return "KahaPersistenceAdapter(" + this.getStoreName() + ")";
    }

    @Override
    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public File getDirectory() {
        return this.directory;
    }

    @Override
    public void setDirectory(File directory) {
        this.directory = directory;
    }

    @Override
    public void checkpoint(boolean sync) throws IOException {
        if (sync) {
            this.getStore().force();
        }
    }

    @Override
    public long size() {
        return this.storeSize.get();
    }

    private void initialize() {
        if (!this.initialized) {
            this.initialized = true;
            if (this.directory == null) {
                File file = new File(IOHelper.getDefaultDataDirectory());
                file = new File(file, IOHelper.toFileSystemSafeName(this.brokerName) + "-kahastore");
                this.setDirectory(file);
            }
            this.directory.mkdirs();
            this.wireFormat.setCacheEnabled(false);
            this.wireFormat.setTightEncodingEnabled(true);
        }
    }
}

