/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.impl.BinaryPredicateSupport;
import org.apache.camel.impl.PredicateSupport;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PredicateBuilder {
    private PredicateBuilder() {
    }

    public static <E extends Exchange> Predicate<E> toPredicate(final Expression<E> expression) {
        return new PredicateSupport<E>(){

            @Override
            public boolean matches(E exchange) {
                Object value = expression.evaluate(exchange);
                return PredicateBuilder.evaluateValuePredicate(value);
            }

            public String toString() {
                return expression.toString();
            }
        };
    }

    public static boolean evaluateValuePredicate(Object value) {
        if (value instanceof Boolean) {
            Boolean aBoolean = (Boolean)value;
            return aBoolean;
        }
        return value != null;
    }

    public static <E extends Exchange> Predicate<E> not(final Predicate<E> predicate) {
        ObjectHelper.notNull(predicate, "predicate");
        return new PredicateSupport<E>(){

            @Override
            public boolean matches(E exchange) {
                return !predicate.matches(exchange);
            }

            public String toString() {
                return "not " + predicate;
            }
        };
    }

    public static <E extends Exchange> Predicate<E> and(final Predicate<E> left, final Predicate<E> right) {
        ObjectHelper.notNull(left, "left");
        ObjectHelper.notNull(right, "right");
        return new PredicateSupport<E>(){

            @Override
            public boolean matches(E exchange) {
                return left.matches(exchange) && right.matches(exchange);
            }

            public String toString() {
                return "(" + left + ") and (" + right + ")";
            }
        };
    }

    public static <E extends Exchange> Predicate<E> or(final Predicate<E> left, final Predicate<E> right) {
        ObjectHelper.notNull(left, "left");
        ObjectHelper.notNull(right, "right");
        return new PredicateSupport<E>(){

            @Override
            public boolean matches(E exchange) {
                return left.matches(exchange) || right.matches(exchange);
            }

            public String toString() {
                return "(" + left + ") or (" + right + ")";
            }
        };
    }

    public static <E extends Exchange> Predicate<E> isEqualTo(Expression<E> left, Expression<E> right) {
        return new BinaryPredicateSupport<E>((Expression)left, (Expression)right){

            @Override
            protected boolean matches(E exchange, Object leftValue, Object rightValue) {
                return ObjectHelper.equal(leftValue, rightValue);
            }

            @Override
            protected String getOperationText() {
                return "==";
            }
        };
    }

    public static <E extends Exchange> Predicate<E> isNotEqualTo(Expression<E> left, Expression<E> right) {
        return new BinaryPredicateSupport<E>((Expression)left, (Expression)right){

            @Override
            protected boolean matches(E exchange, Object leftValue, Object rightValue) {
                return !ObjectHelper.equal(leftValue, rightValue);
            }

            @Override
            protected String getOperationText() {
                return "!=";
            }
        };
    }

    public static <E extends Exchange> Predicate<E> isLessThan(Expression<E> left, Expression<E> right) {
        return new BinaryPredicateSupport<E>((Expression)left, (Expression)right){

            @Override
            protected boolean matches(E exchange, Object leftValue, Object rightValue) {
                return ObjectHelper.compare(leftValue, rightValue) < 0;
            }

            @Override
            protected String getOperationText() {
                return "<";
            }
        };
    }

    public static <E extends Exchange> Predicate<E> isLessThanOrEqualTo(Expression<E> left, Expression<E> right) {
        return new BinaryPredicateSupport<E>((Expression)left, (Expression)right){

            @Override
            protected boolean matches(E exchange, Object leftValue, Object rightValue) {
                return ObjectHelper.compare(leftValue, rightValue) <= 0;
            }

            @Override
            protected String getOperationText() {
                return "<=";
            }
        };
    }

    public static <E extends Exchange> Predicate<E> isGreaterThan(Expression<E> left, Expression<E> right) {
        return new BinaryPredicateSupport<E>((Expression)left, (Expression)right){

            @Override
            protected boolean matches(E exchange, Object leftValue, Object rightValue) {
                return ObjectHelper.compare(leftValue, rightValue) > 0;
            }

            @Override
            protected String getOperationText() {
                return ">";
            }
        };
    }

    public static <E extends Exchange> Predicate<E> isGreaterThanOrEqualTo(Expression<E> left, Expression<E> right) {
        return new BinaryPredicateSupport<E>((Expression)left, (Expression)right){

            @Override
            protected boolean matches(E exchange, Object leftValue, Object rightValue) {
                return ObjectHelper.compare(leftValue, rightValue) >= 0;
            }

            @Override
            protected String getOperationText() {
                return ">=";
            }
        };
    }

    public static <E extends Exchange> Predicate<E> contains(Expression<E> left, Expression<E> right) {
        return new BinaryPredicateSupport<E>((Expression)left, (Expression)right){

            @Override
            protected boolean matches(E exchange, Object leftValue, Object rightValue) {
                return ObjectHelper.contains(leftValue, rightValue);
            }

            @Override
            protected String getOperationText() {
                return "contains";
            }
        };
    }

    public static <E extends Exchange> Predicate<E> isNull(Expression<E> expression) {
        return PredicateBuilder.isEqualTo(expression, ExpressionBuilder.constantExpression(null));
    }

    public static <E extends Exchange> Predicate<E> isNotNull(Expression<E> expression) {
        return PredicateBuilder.isNotEqualTo(expression, ExpressionBuilder.constantExpression(null));
    }

    public static <E extends Exchange> Predicate<E> isInstanceOf(final Expression<E> expression, final Class type) {
        ObjectHelper.notNull(expression, "expression");
        ObjectHelper.notNull(type, "type");
        return new PredicateSupport<E>(){

            @Override
            public boolean matches(E exchange) {
                Object value = expression.evaluate(exchange);
                return type.isInstance(value);
            }

            public String toString() {
                return expression + " instanceof " + type.getName();
            }

            @Override
            protected String assertionFailureMessage(E exchange) {
                return super.assertionFailureMessage(exchange) + " for <" + expression.evaluate(exchange) + ">";
            }
        };
    }

    public static <E extends Exchange> Predicate<E> regex(Expression<E> expression, String regex) {
        return PredicateBuilder.regex(expression, Pattern.compile(regex));
    }

    public static <E extends Exchange> Predicate<E> regex(final Expression<E> expression, final Pattern pattern) {
        ObjectHelper.notNull(expression, "expression");
        ObjectHelper.notNull(pattern, "pattern");
        return new PredicateSupport<E>(){

            @Override
            public boolean matches(E exchange) {
                Object value = expression.evaluate(exchange);
                if (value != null) {
                    Matcher matcher = pattern.matcher(value.toString());
                    return matcher.matches();
                }
                return false;
            }

            public String toString() {
                return expression + ".matches(" + pattern + ")";
            }

            @Override
            protected String assertionFailureMessage(E exchange) {
                return super.assertionFailureMessage(exchange) + " for <" + expression.evaluate(exchange) + ">";
            }
        };
    }
}

