/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging;

import fi.csc.microarray.MicroarrayConfiguration;
import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.messaging.MessagingListener;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.MonitoredNode;
import fi.csc.microarray.messaging.Node;
import fi.csc.microarray.messaging.Topics;
import fi.csc.microarray.messaging.auth.AuthenticatedTopic;
import fi.csc.microarray.messaging.auth.AuthenticationRequestListener;
import fi.csc.microarray.messaging.message.CommandMessage;
import fi.csc.microarray.messaging.message.NamiMessage;
import fi.csc.microarray.util.KeyAndTrustManager;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.log4j.Logger;

public class MessagingEndpoint
implements MessagingListener {
    private static final Logger logger;
    private static final String BROKER_URL;
    private static final String RELIABLE_CONNECTION_SPECIFIER = "failover:";
    private static final boolean USE_RELIABLE;
    private static final String DEFAULT_REPLY_CHANNEL;
    private ActiveMQConnection connection;
    private MessagingTopic adminTopic = null;
    private Node master;
    private AuthenticationRequestListener authenticationListener;

    public MessagingEndpoint(Node master) throws MicroarrayException {
        this(master, null);
    }

    public MessagingEndpoint(Node master, AuthenticationRequestListener authenticationListener) throws MicroarrayException {
        String password;
        String username;
        this.master = master;
        this.authenticationListener = authenticationListener;
        try {
            KeyAndTrustManager.initialise(MicroarrayConfiguration.getValue("security", "keystore"), MicroarrayConfiguration.getValue("security", "keypass").toCharArray(), MicroarrayConfiguration.getValue("security", "keyalias"), MicroarrayConfiguration.getValue("security", "master_keystore"));
        }
        catch (Exception e) {
            throw new MicroarrayException("could not setup SSL connection", e);
        }
        try {
            username = MicroarrayConfiguration.getValue("security", "username");
            if (username == null || username.trim().length() == 0) {
                throw new IllegalArgumentException("Username was not available from configuration");
            }
            password = MicroarrayConfiguration.getValue("security", "password");
            if (password == null || password.trim().length() == 0) {
                throw new IllegalArgumentException("Password was not available from configuration");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("reading authentication information failed: " + e.getMessage());
        }
        try {
            logger.info((Object)("connecting to " + BROKER_URL));
            String brokerUrl = BROKER_URL;
            if (USE_RELIABLE) {
                logger.debug((Object)("testing connecting to " + brokerUrl));
                ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(username, password, brokerUrl);
                TopicConnection tempConnection = connectionFactory.createTopicConnection();
                tempConnection.start();
                tempConnection.stop();
                tempConnection.close();
                brokerUrl = RELIABLE_CONNECTION_SPECIFIER + brokerUrl;
            }
            ActiveMQConnectionFactory reliableConnectionFactory = new ActiveMQConnectionFactory(username, password, brokerUrl);
            this.connection = (ActiveMQConnection)reliableConnectionFactory.createTopicConnection();
            this.connection.setExceptionListener((ExceptionListener)master);
            this.connection.start();
            logger.debug((Object)("connected to " + brokerUrl));
            this.adminTopic = this.createTopic(Topics.Name.ADMIN_TOPIC, MessagingTopic.AccessMode.READ_WRITE);
            this.adminTopic.setListener(this);
            logger.debug((Object)"endpoint created succesfully");
        }
        catch (JMSException e) {
            throw new MicroarrayException("could not connect to message broker at " + BROKER_URL + " (" + e.getMessage() + ")", (Exception)((Object)e));
        }
    }

    public MessagingTopic createTopic(Topics.Name topicName, MessagingTopic.AccessMode accessMode) throws JMSException {
        Session session = this.connection.createSession(false, 1);
        return new AuthenticatedTopic(session, topicName.toString(), MessagingTopic.Type.NORMAL, accessMode, this.authenticationListener, this);
    }

    public void replyToMessage(NamiMessage original, NamiMessage reply) throws JMSException {
        this.replyToMessage(original, reply, DEFAULT_REPLY_CHANNEL);
    }

    public void replyToMessage(NamiMessage original, NamiMessage reply, String replyChannel) throws JMSException {
        reply.setMultiplexChannel(replyChannel);
        Destination replyToDest = original.getReplyTo();
        this.replyToMessage(replyToDest, reply);
    }

    private void replyToMessage(Destination replyToDest, NamiMessage reply) throws JMSException {
        Session session = this.connection.createSession(false, 1);
        MapMessage msg = session.createMapMessage();
        reply.marshal(msg);
        session.createProducer(replyToDest).send((Message)msg);
    }

    public void onNamiMessage(NamiMessage msg) {
        try {
            CommandMessage txtMsg = (CommandMessage)msg;
            logger.debug((Object)("got admin request " + txtMsg.getCommand()));
            if (txtMsg.getCommand().equals("ping")) {
                CommandMessage reply = new CommandMessage("ping-reply");
                reply.addParameter(this.master.getName());
                reply.addParameter(this.master.getHost());
                this.adminTopic.sendMessage(reply);
                logger.debug((Object)("sent ping-reply from " + this.master.getHost() + "/" + this.master.getName()));
            } else if (txtMsg.getCommand().equals("request-load-info") && this.master instanceof MonitoredNode) {
                CommandMessage reply = new CommandMessage("request-load-info-reply");
                MonitoredNode mMaster = (MonitoredNode)this.master;
                reply.addParameter(this.master.getName());
                reply.addParameter(Long.toString(mMaster.countRequestsInProcessing()));
                reply.addParameter(Long.toString(mMaster.getLastProcessingTime()));
                this.adminTopic.sendMessage(reply);
                logger.debug((Object)("sent request-load-info-reply from " + this.master.getHost() + "/" + this.master.getName()));
            }
        }
        catch (JMSException e) {
            logger.error((Object)e);
        }
    }

    public void close() throws JMSException {
        this.connection.stop();
        this.connection.close();
    }

    public AuthenticationRequestListener getAuthenticationListener() {
        return this.authenticationListener;
    }

    public void setAuthenticationListener(AuthenticationRequestListener authenticationListener) {
        this.authenticationListener = authenticationListener;
    }

    public OutputStream createOutputStream(Topic topic) throws JMSException {
        return this.connection.createOutputStream((Destination)topic);
    }

    public InputStream createInputStream(Topic topic) throws JMSException {
        return this.connection.createInputStream((Destination)topic);
    }

    static {
        String protocol = MicroarrayConfiguration.getValue("messaging", "broker_protocol");
        String host = MicroarrayConfiguration.getValue("messaging", "broker_host");
        String port = MicroarrayConfiguration.getValue("messaging", "broker_port");
        if (protocol == null || host == null || port == null) {
            throw new RuntimeException("configuration error: protocol, host or port not set");
        }
        if (protocol.trim().equals("") || host.trim().equals("") || port.trim().equals("")) {
            throw new RuntimeException("configuration error: protocol, host or port empty");
        }
        BROKER_URL = protocol + "://" + host + ":" + port;
        logger = Logger.getLogger(MessagingEndpoint.class);
        USE_RELIABLE = "true".equals(MicroarrayConfiguration.getValue("messaging", "use_reliable"));
        DEFAULT_REPLY_CHANNEL = Topics.MultiplexName.REPLY_TO.toString();
    }
}

