/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client;

import bsh.EvalError;
import bsh.Interpreter;
import fi.csc.microarray.AdminAPI;
import fi.csc.microarray.MicroarrayConfiguration;
import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.AtEndListener;
import fi.csc.microarray.client.ClientConstants;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.dataimport.ImportItem;
import fi.csc.microarray.client.dataimport.ImportSession;
import fi.csc.microarray.client.dataimport.ImportUtils;
import fi.csc.microarray.client.dialog.ChipsterDialog;
import fi.csc.microarray.client.dialog.DialogInfo;
import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.operation.OperationCategory;
import fi.csc.microarray.client.operation.OperationDefinition;
import fi.csc.microarray.client.operation.OperationGenerator;
import fi.csc.microarray.client.selection.DataSelectionManager;
import fi.csc.microarray.client.tasks.Task;
import fi.csc.microarray.client.tasks.TaskEventListener;
import fi.csc.microarray.client.tasks.TaskException;
import fi.csc.microarray.client.tasks.TaskExecutor;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrameManager;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.client.visualisation.VisualisationMethodChangedEvent;
import fi.csc.microarray.client.workflow.WorkflowManager;
import fi.csc.microarray.databeans.ContentType;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataFolder;
import fi.csc.microarray.databeans.DataItem;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.databeans.features.table.EditableTable;
import fi.csc.microarray.databeans.features.table.TableBeanEditor;
import fi.csc.microarray.databeans.fs.FSDataManager;
import fi.csc.microarray.description.ParsedVVSADL;
import fi.csc.microarray.messaging.MessagingEndpoint;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.Node;
import fi.csc.microarray.messaging.NodeBase;
import fi.csc.microarray.messaging.Topics;
import fi.csc.microarray.messaging.auth.AuthenticationRequestListener;
import fi.csc.microarray.module.Module;
import fi.csc.microarray.module.Modules;
import fi.csc.microarray.module.basic.BasicModule;
import fi.csc.microarray.module.chipster.ChipsterVVSADLParser;
import fi.csc.microarray.module.chipster.MicroarrayModule;
import fi.csc.microarray.module.stats.StatsModule;
import fi.csc.microarray.util.Files;
import fi.csc.microarray.util.Strings;
import fi.csc.microarray.wizard.WizardContext;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.jms.JMSException;
import javax.swing.Icon;
import javax.swing.Timer;
import org.apache.log4j.Logger;
import org.mortbay.util.IO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClientApplication
implements Node,
WizardContext {
    private static final int HEARTBEAT_DELAY = 2000;
    private static Logger logger;
    public static File SNAPSHOT_DIR;
    public static File OLD_SNAPSHOT_DIR;
    private PropertyChangeListener jobExecutorChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            ClientApplication.this.taskCountChanged((Integer)evt.getNewValue(), true);
            logger.debug((Object)("JobExecutor property changed event: " + evt.getPropertyName() + ": " + (Integer)evt.getNewValue()));
        }
    };
    private NodeBase nodeSupport = new NodeBase(){

        public String getName() {
            return "client";
        }
    };
    protected Collection<OperationCategory> parsedCategories;
    protected String metadata;
    protected CountDownLatch definitionsInitialisedLatch = new CountDownLatch(1);
    private boolean eventsEnabled = false;
    private PropertyChangeSupport eventSupport = new PropertyChangeSupport(this);
    protected WorkflowManager workflowManager = new WorkflowManager(this);
    protected TaskExecutor taskExecutor;
    protected MessagingEndpoint endpoint;
    protected DataManager manager;
    protected DataSelectionManager selectionManager;

    protected abstract AuthenticationRequestListener getAuthenticationRequestListener();

    public abstract void reportException(Exception var1);

    public abstract void reportTaskError(Task var1) throws MicroarrayException;

    protected abstract void taskCountChanged(int var1, boolean var2);

    public abstract DataBean importData(String var1, ContentType var2, String var3, Object var4, DataBean var5);

    @Override
    public abstract void importGroup(Collection<ImportItem> var1, String var2);

    public abstract void showSourceFor(String var1) throws TaskException;

    public abstract void showHistoryScreenFor(DataBean var1);

    public abstract void showDetailsFor(DataBean var1);

    public abstract void showPopupMenuFor(MouseEvent var1, DataItem var2);

    public abstract void showPopupMenuFor(MouseEvent var1, List<DataItem> var2);

    public abstract void showImportToolFor(File var1, String var2, boolean var3);

    @Override
    public abstract void visualiseWithBestMethod(VisualisationFrameManager.FrameType var1);

    public abstract void reportInitialisation(String var1, boolean var2);

    public abstract Icon getIconFor(DataItem var1);

    public abstract void setBusyMode(boolean var1);

    public abstract void viewHelp(String var1);

    public abstract void viewHelpFor(OperationDefinition var1);

    public abstract void showDialog(String var1, String var2, String var3, DialogInfo.Severity var4, boolean var5);

    public abstract void showDialog(String var1, String var2, String var3, DialogInfo.Severity var4, boolean var5, ChipsterDialog.DetailsVisibility var6);

    public abstract void deleteDatas(List<DataBean> var1, boolean var2);

    public abstract void deleteData(DataItem var1, boolean var2);

    public abstract void createLink(DataBean var1, DataBean var2, DataBean.Link var3);

    public abstract void removeLink(DataBean var1, DataBean var2, DataBean.Link var3);

    public abstract File saveWorkflow();

    public abstract File openWorkflow();

    public abstract void saveSnapshot();

    public abstract void flipTaskListVisibility(boolean var1);

    public abstract void setMaximisedVisualisationMode(boolean var1);

    public abstract VisualisationFrameManager getVisualisationFrameManager();

    public abstract void runBlockingTask(String var1, Runnable var2);

    public abstract void loadSnapshot();

    public abstract void heartBeat();

    protected void initialiseApplication() throws MicroarrayException, IOException {
        logger = Logger.getLogger(ClientApplication.class);
        SNAPSHOT_DIR = new File(MicroarrayConfiguration.getWorkDir().getAbsolutePath() + File.separator + "session-snapshot.zip");
        OLD_SNAPSHOT_DIR = new File(MicroarrayConfiguration.getWorkDir().getAbsolutePath() + File.separator + "workspace-snapshot");
        Modules modules = new Modules();
        for (Module module : this.loadModules()) {
            modules.addModule(module);
        }
        Session.getSession().putObject("modules", modules);
        this.manager = new FSDataManager();
        modules.plugFeatures(this.manager);
        Session.getSession().putObject("data-manager", this.manager);
        this.selectionManager = new DataSelectionManager(this);
        Session.getSession().putObject("application", this);
        try {
            logger.debug((Object)"Initialise JMS connection.");
            this.reportInitialisation("Connecting to broker at " + MicroarrayConfiguration.getValue("messaging", "broker_host") + "...", true);
            this.endpoint = new MessagingEndpoint(this, this.getAuthenticationRequestListener());
            this.reportInitialisation(" connected", false);
            Session.getSession().putObject("client-endpoint", this.endpoint);
            this.taskExecutor = new TaskExecutor(this.endpoint, this.manager);
            Session.getSession().putObject("client-job-executor", this.taskExecutor);
            this.reportInitialisation("Checking remote services...", true);
            AdminAPI api = new AdminAPI(this.endpoint.createTopic(Topics.Name.ADMIN_TOPIC, MessagingTopic.AccessMode.READ_WRITE), null);
            if (!api.areAllServicesUp(true)) {
                throw new Exception("required services are not available (" + api.getErrorStatus() + ")");
            }
            this.reportInitialisation(" all are available", false);
            this.reportInitialisation("Fetching analysis descriptions...", true);
            Task describeOperations = this.taskExecutor.createTask("describe", true);
            this.taskExecutor.execute(describeOperations);
            this.metadata = new String(describeOperations.getOutput("description").getContents());
            logger.debug((Object)("got metadata: " + this.metadata.substring(0, 50) + "..."));
            List<ParsedVVSADL> descriptions = new ChipsterVVSADLParser().parseMultiple(this.metadata);
            this.parsedCategories = new OperationGenerator().generate(descriptions).values();
            logger.debug((Object)("created " + this.parsedCategories.size() + " operation categories"));
            this.reportInitialisation(" received and processed", false);
            this.definitionsInitialisedLatch.countDown();
            this.taskExecutor.addChangeListener(this.jobExecutorChangeListener);
            Timer timer = new Timer(2000, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ClientApplication.this.heartBeat();
                }
            });
            timer.setCoalesce(true);
            timer.setRepeats(true);
            timer.setInitialDelay(0);
            timer.start();
        }
        catch (Exception e) {
            this.showDialog("Starting Chipster failed.", "There could be a problem with the network connection, or the remote services could be down. Please see the details below for more information about the problem.\n\nChipster also fails to start if there has been a version update with a change in configurations. In such case please delete the \"nami-work-files\" directory in your home directory.", e.toString(), DialogInfo.Severity.ERROR, false);
            throw new MicroarrayException(e);
        }
    }

    private Module[] loadModules() {
        return new Module[]{new BasicModule(), new StatsModule(), new MicroarrayModule()};
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.eventSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.eventSupport.removePropertyChangeListener(listener);
    }

    public List<DataBean> getAllDataBeans() {
        ArrayList<DataBean> datas = new ArrayList<DataBean>();
        for (DataItem item1 : this.manager.getRootFolder().getChildren()) {
            if (!(item1 instanceof DataFolder)) continue;
            DataFolder folder = (DataFolder)item1;
            for (DataItem item2 : folder.getChildren()) {
                if (!(item2 instanceof DataBean)) continue;
                DataBean bean = (DataBean)item2;
                datas.add(bean);
            }
        }
        return datas;
    }

    @Override
    public DataSelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    public void selectAllItems() {
        List<DataBean> datas = this.getAllDataBeans();
        for (DataBean data : datas) {
            this.selectionManager.selectMultiple(data, this);
        }
    }

    @Override
    public void setVisualisationMethod(VisualisationMethod method, List<Visualisation.Variable> variables, List<DataBean> datas, VisualisationFrameManager.FrameType target) {
        this.dispatchVisualisationEvent(new VisualisationMethodChangedEvent(this, method, variables, datas, target));
    }

    public void setVisualisationMethod(VisualisationMethodChangedEvent e) {
        this.dispatchEvent(e);
    }

    public void setEventsEnabled(boolean eventsEnabled) {
        this.eventsEnabled = eventsEnabled;
        this.taskExecutor.setEventsEnabled(eventsEnabled);
    }

    @Override
    public String getName() {
        return this.nodeSupport.getName();
    }

    @Override
    public String getHost() {
        return this.nodeSupport.getHost();
    }

    public void renameDataItem(DataItem data, String newName) {
        data.setName(newName);
    }

    public void executeOperation(OperationDefinition operationDefinition, Operation.ResultListener resultListener) {
        try {
            Operation operation = new Operation(operationDefinition, this.getSelectionManager().getSelectedDatasAsArray());
            operation.setResultListener(resultListener);
            this.executeOperation(operation);
        }
        catch (MicroarrayException e) {
            this.reportException(e);
        }
    }

    @Override
    public void executeOperation(final Operation operation) {
        if (operation.getBindings() == null) {
            throw new RuntimeException("Attempted to run " + operation.getDefinition().getFullName() + " with input datasets that were not compatitible with the operation.");
        }
        if (this.taskExecutor.getRunningTaskCount() >= ClientConstants.MAX_JOBS) {
            this.showDialog("Task not started as there are maximum number of tasks already running.", "You can only run " + ClientConstants.MAX_JOBS + " tasks at the same time. Please wait for one of the currently running tasks to finish and try again.", null, DialogInfo.Severity.INFO, false);
            return;
        }
        long bytes = 0L;
        for (Operation.DataBinding binding : operation.getBindings()) {
            bytes += binding.getData().getContentLength();
        }
        if (bytes > ClientConstants.MAX_JOB_SIZE) {
            this.showDialog("Task not started since input datasets are too large.", "Maximum size for input datasets is " + ClientConstants.MAX_JOB_SIZE + " bytes.", "Input datasets size: " + bytes, DialogInfo.Severity.INFO, false);
            return;
        }
        operation.execute(new TaskEventListener(){

            public void onStateChange(Task job, Task.State oldState, Task.State newState) {
                if (newState.isFinished()) {
                    try {
                        ClientApplication.this.onFinishedTask(job, operation);
                    }
                    catch (Exception e) {
                        ClientApplication.this.reportException(e);
                    }
                }
            }
        });
    }

    public void onFinishedTask(Task job, Operation oper) throws MicroarrayException, IOException {
        logger.debug((Object)("operation finished, state is " + (Object)((Object)job.getState())));
        if (job.getState() != Task.State.CANCELLED) {
            if (!job.getState().finishedSuccesfully()) {
                this.reportTaskError(job);
            } else {
                LinkedList<DataBean> newBeans = new LinkedList<DataBean>();
                LinkedList<DataBean> sources = new LinkedList<DataBean>();
                for (Operation.DataBinding binding : oper.getBindings()) {
                    if (binding.getData().queryFeatures("/phenodata").exists()) continue;
                    sources.add(binding.getData());
                }
                DataFolder folder = oper.getOutputFolder() != null ? oper.getOutputFolder() : (sources.size() > 0 ? ((DataBean)sources.get(0)).getParent() : this.manager.getRootFolder());
                DataBean phenodata = null;
                for (String outputName : job.outputNames()) {
                    DataBean result = job.getOutput(outputName);
                    result.setOperation(oper);
                    if (result.queryFeatures("/phenodata").exists()) {
                        phenodata = job.getOutput(outputName);
                    }
                    for (DataBean source : sources) {
                        result.addLink(DataBean.Link.DERIVATION, source);
                    }
                    try {
                        result.initialiseStreamStartCache();
                    }
                    catch (IOException e) {
                        throw new MicroarrayException(e);
                    }
                    folder.addChild(result);
                    newBeans.add(result);
                }
                if (phenodata != null) {
                    for (DataBean bean : newBeans) {
                        if (bean == phenodata) continue;
                        phenodata.addLink(DataBean.Link.ANNOTATION, bean);
                    }
                    if (!phenodata.queryFeatures("/column/original_name").exists()) {
                        HashSet<String> insertedNames = new HashSet<String>();
                        TableBeanEditor tableEditor = new TableBeanEditor(phenodata);
                        EditableTable editableTable = tableEditor.getEditable();
                        LinkedList<String> newColumn = new LinkedList<String>();
                        newColumn.addAll(Arrays.asList(Strings.repeatToArray("", editableTable.getRowCount())));
                        editableTable.addColumn("original_name", 1, newColumn);
                        for (int ri = 0; ri < editableTable.getRowCount(); ++ri) {
                            String sample = editableTable.getValue("sample", ri);
                            boolean correctRowFound = false;
                            String originalName = null;
                            for (Operation.DataBinding binding : oper.getBindings()) {
                                if (!binding.getName().equals(sample)) continue;
                                originalName = binding.getData().getName();
                                correctRowFound = true;
                                break;
                            }
                            if (!correctRowFound) {
                                originalName = sample;
                            }
                            if (insertedNames.contains(originalName)) {
                                String separator = "/";
                                int i = 2;
                                while (insertedNames.contains(originalName + "/" + i)) {
                                    ++i;
                                }
                                originalName = originalName + "/" + i;
                            }
                            editableTable.setValue("original_name", ri, originalName);
                            insertedNames.add(originalName);
                        }
                        tableEditor.write();
                    }
                    if (!phenodata.queryFeatures("/column/description").exists()) {
                        TableBeanEditor tableEditor = new TableBeanEditor(phenodata);
                        EditableTable editableTable = tableEditor.getEditable();
                        LinkedList<String> newColumn = new LinkedList<String>();
                        newColumn.addAll(Arrays.asList(Strings.repeatToArray("", editableTable.getRowCount())));
                        editableTable.addColumn("description", newColumn);
                        for (int ri = 0; ri < editableTable.getRowCount(); ++ri) {
                            String sample = editableTable.getValue("original_name", ri);
                            editableTable.setValue("description", ri, sample);
                        }
                        tableEditor.write();
                    }
                }
                if (oper.getResultListener() != null) {
                    oper.getResultListener().resultData(newBeans);
                }
            }
        }
    }

    protected void quit() {
        logger.debug((Object)"quitting client");
        try {
            this.endpoint.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public void dispatchVisualisationEvent(VisualisationMethodChangedEvent event) {
        logger.debug((Object)("VisualisationEvent dispatched: " + (Object)((Object)event.getNewMethod())));
        this.dispatchEvent(event);
    }

    public void dispatchEvent(PropertyChangeEvent event) {
        logger.debug((Object)("dispatching event: " + event));
        if (this.eventsEnabled) {
            this.eventSupport.firePropertyChange(event);
        }
    }

    public List<File> getWorkflows() {
        return this.workflowManager.getWorkflows();
    }

    public void fetchSourceFor(String[] operationNames, final SourceCodeListener listener) throws MicroarrayException {
        try {
            int i = -1;
            for (String name : operationNames) {
                ++i;
                logger.debug((Object)("describe operation " + name));
                if (name == null) {
                    listener.updateSourceCodeAt(i, null);
                    continue;
                }
                final Task describeTask = this.taskExecutor.createTask("describe-operation", true);
                final int index = i;
                describeTask.addParameter("name", name);
                describeTask.addTaskEventListener(new TaskEventListener(){

                    public void onStateChange(Task job, Task.State oldState, Task.State newState) {
                        if (newState == Task.State.COMPLETED) {
                            try {
                                String source = new String(describeTask.getOutput("sourcecode").getContents());
                                logger.debug((Object)source);
                                listener.updateSourceCodeAt(index, source);
                            }
                            catch (MicroarrayException e) {
                                ClientApplication.this.reportException(e);
                            }
                        }
                    }
                });
                this.taskExecutor.startExecuting(describeTask);
            }
        }
        catch (TaskException e) {
            throw new MicroarrayException(e);
        }
    }

    public void importWholeDirectory(File root) {
        LinkedList<File> onlyFiles = new LinkedList<File>();
        for (File file : root.listFiles()) {
            if (!file.isFile()) continue;
            onlyFiles.add(file);
        }
        ImportSession importSession = new ImportSession(ImportSession.Source.CLIPBOARD, onlyFiles, root.getName(), true);
        ImportUtils.executeImport(importSession);
    }

    public void runWorkflow(String scriptName) {
        this.runWorkflow(new File(WorkflowManager.SCRIPT_DIRECTORY.getPath() + File.separator + scriptName + "." + "bsh"));
    }

    public void runWorkflow(File scriptFile) {
        this.workflowManager.runScript(scriptFile, null);
    }

    public void openScriptConsole() {
        Interpreter i = this.workflowManager.initialiseBshEnvironment();
        try {
            i.eval("desktop()");
        }
        catch (EvalError ee) {
            throw new RuntimeException("BeanShell console failed to open: " + ee.getMessage());
        }
    }

    public void runScriptFile(String fileName, AtEndListener atEndListener) throws IOException {
        this.workflowManager.runScript(new File(fileName), atEndListener);
    }

    @Override
    public OperationDefinition locateOperationDefinition(String categoryName, String operationName) {
        for (OperationCategory category : this.parsedCategories) {
            if (!category.getName().equals(categoryName)) continue;
            for (OperationDefinition definition : category.getOperationList()) {
                if (!definition.getName().equals(operationName)) continue;
                return definition;
            }
        }
        return null;
    }

    public void loadSnapshot(File snapshotDir) throws IOException, MicroarrayException {
        this.manager.loadSnapshot(snapshotDir, this.manager.getRootFolder(), this);
    }

    public void loadOldSnapshot() throws IOException, MicroarrayException {
        this.manager.loadOldSnapshot(OLD_SNAPSHOT_DIR, this.manager.getRootFolder(), this);
    }

    public Iterable<OperationDefinition> getOperationDefinitions() {
        LinkedList<OperationDefinition> definitions = new LinkedList<OperationDefinition>();
        for (OperationCategory category : this.parsedCategories) {
            for (OperationDefinition operationDefinition : category.getOperationList()) {
                definitions.add(operationDefinition);
            }
        }
        return definitions;
    }

    protected void exportToFile(final DataBean data, final File selectedFile) {
        this.runBlockingTask("exporting file", new Runnable(){

            public void run() {
                try {
                    File newFile = selectedFile;
                    int i = 1;
                    while (newFile.exists()) {
                        String[] parts = Files.parseFilename(selectedFile);
                        newFile = new File(parts[0] + File.separator + parts[1] + "_" + ++i + "." + parts[2]);
                    }
                    newFile.createNewFile();
                    FileOutputStream out = new FileOutputStream(newFile);
                    IO.copy((InputStream)data.getContentByteStream(), (OutputStream)out);
                    out.close();
                }
                catch (Exception e) {
                    throw new RuntimeException();
                }
            }
        });
    }

    public TaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    static {
        SNAPSHOT_DIR = null;
        OLD_SNAPSHOT_DIR = null;
    }

    public static interface SourceCodeListener {
        public void updateSourceCodeAt(int var1, String var2);
    }
}

