/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.index;

import java.io.IOException;
import org.apache.activemq.kaha.StoreEntry;
import org.apache.activemq.kaha.impl.index.IndexItem;
import org.apache.activemq.kaha.impl.index.IndexLinkedList;
import org.apache.activemq.kaha.impl.index.IndexManager;

public class DiskIndexLinkedList
implements IndexLinkedList {
    protected IndexManager indexManager;
    protected transient IndexItem root;
    protected transient IndexItem last;
    protected transient int size;

    public DiskIndexLinkedList(IndexManager im, IndexItem header) {
        this.indexManager = im;
        this.root = header;
    }

    public synchronized IndexItem getRoot() {
        return this.root;
    }

    public void setRoot(IndexItem e) {
        this.root = e;
    }

    public synchronized IndexItem getFirst() {
        if (this.size == 0) {
            return null;
        }
        return this.getNextEntry(this.root);
    }

    public synchronized IndexItem getLast() {
        if (this.size == 0) {
            return null;
        }
        if (this.last != null) {
            this.last.next = null;
            this.last.setNextItem(-1L);
        }
        return this.last;
    }

    public synchronized StoreEntry removeFirst() {
        if (this.size == 0) {
            return null;
        }
        IndexItem result = this.getNextEntry(this.root);
        this.remove(result);
        return result;
    }

    public synchronized Object removeLast() {
        if (this.size == 0) {
            return null;
        }
        IndexItem result = this.last;
        this.remove(this.last);
        return result;
    }

    public synchronized void addFirst(IndexItem item) {
        if (this.size == 0) {
            this.last = item;
        }
        ++this.size;
    }

    public synchronized void addLast(IndexItem item) {
        ++this.size;
        this.last = item;
    }

    public synchronized int size() {
        return this.size;
    }

    public synchronized boolean isEmpty() {
        return this.size == 0;
    }

    public synchronized boolean add(IndexItem item) {
        this.addLast(item);
        return true;
    }

    public synchronized void clear() {
        this.last = null;
        this.size = 0;
    }

    public synchronized IndexItem get(int index) {
        return this.entry(index);
    }

    public synchronized void add(int index, IndexItem element) {
        if (index == this.size) {
            this.last = element;
        }
        ++this.size;
    }

    public synchronized Object remove(int index) {
        IndexItem e = this.entry(index);
        this.remove(e);
        return e;
    }

    private IndexItem entry(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        IndexItem e = this.root;
        for (int i = 0; i <= index; ++i) {
            e = this.getNextEntry(e);
        }
        if (e != null && this.last != null && this.last.equals(e)) {
            this.last = e;
        }
        return e;
    }

    public synchronized int indexOf(StoreEntry o) {
        int index = 0;
        if (this.size > 0) {
            IndexItem e = this.getNextEntry(this.root);
            while (e != null) {
                if (o.equals(e)) {
                    return index;
                }
                ++index;
                e = this.getNextEntry(e);
            }
        }
        return -1;
    }

    public synchronized IndexItem getNextEntry(IndexItem current) {
        IndexItem result = null;
        if (current != null && (current = (IndexItem)this.refreshEntry(current)).getNextItem() >= 0L) {
            try {
                result = this.indexManager.getIndex(current.getNextItem());
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to get next index from " + this.indexManager + " for " + current, e);
            }
        }
        if (result != null && this.last != null && this.last.equals(result)) {
            this.last = result;
        }
        return result;
    }

    public synchronized IndexItem getPrevEntry(IndexItem current) {
        IndexItem result = null;
        if (current != null && current.getPreviousItem() >= 0L) {
            current = (IndexItem)this.refreshEntry(current);
            try {
                result = this.indexManager.getIndex(current.getPreviousItem());
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to  get current index for " + current, e);
            }
        }
        if (result != null && this.root != null && this.root.equals(result)) {
            return null;
        }
        return result;
    }

    public synchronized StoreEntry getEntry(StoreEntry current) {
        IndexItem result = null;
        if (current != null && current.getOffset() >= 0L) {
            try {
                result = this.indexManager.getIndex(current.getOffset());
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to index", e);
            }
        }
        if (result != null && this.root != null && this.root.equals(result)) {
            return this.root;
        }
        return result;
    }

    public synchronized StoreEntry refreshEntry(StoreEntry current) {
        IndexItem result = null;
        if (current != null && current.getOffset() >= 0L) {
            try {
                result = this.indexManager.refreshIndex((IndexItem)current);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to index", e);
            }
        }
        if (result != null && this.root != null && this.root.equals(result)) {
            return this.root;
        }
        return result;
    }

    public synchronized void remove(IndexItem e) {
        if (e == null || e == this.root || e.equals(this.root)) {
            return;
        }
        if (e == this.last || e.equals(this.last)) {
            if (this.size > 1) {
                this.last = (IndexItem)this.refreshEntry(this.last);
                this.last = this.getPrevEntry(this.last);
            } else {
                this.last = null;
            }
        }
        --this.size;
    }
}

