/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.RepaintManager;
import javax.swing.Scrollable;
import org.jdesktop.swingx.RepaintManagerX;
import org.jdesktop.swingx.TranslucentRepaintManager;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.painter.Painter;

public class JXPanel
extends JPanel
implements Scrollable {
    private boolean scrollableTracksViewportHeight;
    private boolean scrollableTracksViewportWidth;
    private float alpha = 1.0f;
    private boolean oldOpaque;
    private boolean inheritAlpha = true;
    private Painter backgroundPainter;
    private boolean paintBorderInsets = true;

    public JXPanel() {
        this.initPainterSupport();
    }

    public JXPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
        this.initPainterSupport();
    }

    public JXPanel(LayoutManager layout) {
        super(layout);
        this.initPainterSupport();
    }

    public JXPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
        this.initPainterSupport();
    }

    private void initPainterSupport() {
        if (this.backgroundPainter == null) {
            this.backgroundPainter = new AbstractPainter<JXPanel>(){

                @Override
                protected void doPaint(Graphics2D g, JXPanel component, int width, int height) {
                    JXPanel.super.paintComponent(g);
                }
            };
        }
    }

    public void setAlpha(float alpha) {
        if (this.alpha != alpha) {
            assert (alpha >= 0.0f && (double)alpha <= 1.0);
            float oldAlpha = this.alpha;
            this.alpha = alpha;
            if (alpha > 0.0f && alpha < 1.0f) {
                RepaintManager manager;
                if (oldAlpha == 1.0f) {
                    this.oldOpaque = this.isOpaque();
                    this.setOpaque(false);
                }
                if (!(manager = RepaintManager.currentManager(this)).getClass().isAnnotationPresent(TranslucentRepaintManager.class)) {
                    RepaintManager.setCurrentManager(new RepaintManagerX());
                }
            } else if (alpha == 1.0f && this.oldOpaque) {
                this.setOpaque(true);
            }
            this.firePropertyChange("alpha", oldAlpha, alpha);
            this.repaint();
        }
    }

    public float getAlpha() {
        return this.alpha;
    }

    public float getEffectiveAlpha() {
        if (this.inheritAlpha) {
            float a = this.alpha;
            Container c = this;
            while ((c = c.getParent()) != null) {
                if (!(c instanceof JXPanel)) continue;
                a = Math.min(((JXPanel)c).getAlpha(), a);
            }
            return a;
        }
        return this.alpha;
    }

    public boolean isInheritAlpha() {
        return this.inheritAlpha;
    }

    public void setInheritAlpha(boolean val) {
        if (this.inheritAlpha != val) {
            this.inheritAlpha = val;
            this.firePropertyChange("inheritAlpha", !this.inheritAlpha, this.inheritAlpha);
        }
    }

    public boolean getScrollableTracksViewportHeight() {
        return this.scrollableTracksViewportHeight;
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.scrollableTracksViewportWidth;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    public void setScrollableTracksViewportHeight(boolean scrollableTracksViewportHeight) {
        this.scrollableTracksViewportHeight = scrollableTracksViewportHeight;
    }

    public void setScrollableTracksViewportWidth(boolean scrollableTracksViewportWidth) {
        this.scrollableTracksViewportWidth = scrollableTracksViewportWidth;
    }

    public void setBackgroundPainter(Painter p) {
        Painter old = this.getBackgroundPainter();
        this.backgroundPainter = p;
        this.firePropertyChange("backgroundPainter", old, this.getBackgroundPainter());
        this.repaint();
    }

    public Painter getBackgroundPainter() {
        return this.backgroundPainter;
    }

    public boolean isPaintBorderInsets() {
        return this.paintBorderInsets;
    }

    public void setPaintBorderInsets(boolean paintBorderInsets) {
        boolean old = this.isPaintBorderInsets();
        this.paintBorderInsets = paintBorderInsets;
        this.firePropertyChange("paintBorderInsets", old, this.isPaintBorderInsets());
    }

    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Composite oldComp = g2d.getComposite();
        float alpha = this.getEffectiveAlpha();
        AlphaComposite alphaComp = AlphaComposite.getInstance(3, alpha);
        g2d.setComposite(alphaComp);
        super.paint(g2d);
        g2d.setComposite(oldComp);
    }

    protected void paintComponent(Graphics g) {
        if (this.backgroundPainter != null) {
            if (this.isOpaque()) {
                super.paintComponent(g);
            }
            Graphics2D g2 = (Graphics2D)g.create();
            if (this.isPaintBorderInsets()) {
                this.backgroundPainter.paint(g2, this, this.getWidth(), this.getHeight());
            } else {
                Insets ins = this.getInsets();
                g2.translate(ins.left, ins.top);
                this.backgroundPainter.paint(g2, this, this.getWidth() - ins.left - ins.right, this.getHeight() - ins.top - ins.bottom);
            }
            g2.dispose();
        } else {
            super.paintComponent(g);
        }
    }
}

