/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dataimport;

import fi.csc.microarray.databeans.ContentType;
import java.io.File;

public class ImportItem {
    private File input;
    private File output;
    private Action action;
    private ContentType type;

    public ImportItem(File input) {
        this.input = input;
        this.output = input.getAbsoluteFile();
    }

    public File getInput() {
        return this.input;
    }

    public File getOutput() {
        return this.output;
    }

    public Action getAction() {
        return this.action;
    }

    public void setFilename(String output) {
        this.output = new File(this.output.getParentFile().getPath() + File.separator + output);
    }

    public ContentType getType() {
        return this.type;
    }

    public void setType(ContentType type) {
        this.type = type;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public String toString() {
        return "ImportItem [input: " + this.input.getName() + ", output: " + this.output.getName() + ", type: " + this.type.getType() + ", action: " + this.action.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        DIRECT("Import directly"),
        CUSTOM("Use Import tool"),
        IGNORE("Don't import");

        private String name;

        private Action(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

