/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientFocusTraversalPolicy
extends FocusTraversalPolicy {
    Vector<Component> order;
    private static final Logger logger = Logger.getLogger(ClientFocusTraversalPolicy.class);

    public ClientFocusTraversalPolicy(Vector<Component> order) {
        this.order = new Vector(order.size());
        this.order.addAll(order);
    }

    @Override
    public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
        int idx = (this.order.indexOf(aComponent) + 1) % this.order.size();
        logger.debug("Focus moved to next component: " + this.order.get(idx));
        Component comp = this.order.get(idx);
        if (!comp.isEnabled()) {
            comp = this.getComponentAfter(focusCycleRoot, comp);
        }
        return comp;
    }

    @Override
    public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
        int idx = this.order.indexOf(aComponent) - 1;
        if (idx < 0) {
            idx = this.order.size() - 1;
        }
        logger.debug("Focus moved to previous component: " + this.order.get(idx));
        Component comp = this.order.get(idx);
        if (!comp.isEnabled()) {
            comp = this.getComponentBefore(focusCycleRoot, comp);
        }
        return comp;
    }

    @Override
    public Component getDefaultComponent(Container focusCycleRoot) {
        logger.debug("Focus moved to default component: " + this.order.get(0));
        Component comp = this.order.get(0);
        if (!comp.isEnabled()) {
            comp = this.getComponentAfter(focusCycleRoot, comp);
        }
        return comp;
    }

    @Override
    public Component getLastComponent(Container focusCycleRoot) {
        logger.debug("Focus moved to last component: " + this.order.lastElement());
        Component comp = this.order.lastElement();
        if (!comp.isEnabled()) {
            comp = this.getComponentBefore(focusCycleRoot, comp);
        }
        return comp;
    }

    @Override
    public Component getFirstComponent(Container focusCycleRoot) {
        logger.debug("Focus moved to first component: " + this.order.get(0));
        return this.getDefaultComponent(focusCycleRoot);
    }
}

