/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.journal;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.activeio.journal.InvalidRecordLocationException;
import org.apache.activeio.journal.Journal;
import org.apache.activeio.journal.JournalEventListener;
import org.apache.activeio.journal.RecordLocation;
import org.apache.activeio.packet.Packet;
import org.apache.activeio.stats.CountStatisticImpl;
import org.apache.activeio.stats.IndentPrinter;
import org.apache.activeio.stats.TimeStatisticImpl;

public class JournalStatsFilter
implements Journal {
    private final TimeStatisticImpl writeLatency = new TimeStatisticImpl("writeLatency", "The amount of time that is spent waiting for a record to be written to the Journal");
    private final CountStatisticImpl writeRecordsCounter = new CountStatisticImpl("writeRecordsCounter", "The number of records that have been written by the Journal");
    private final CountStatisticImpl writeBytesCounter = new CountStatisticImpl("writeBytesCounter", "The number of bytes that have been written by the Journal");
    private final TimeStatisticImpl synchedWriteLatency = new TimeStatisticImpl(this.writeLatency, "synchedWriteLatency", "The amount of time that is spent waiting for a synch record to be written to the Journal");
    private final TimeStatisticImpl unsynchedWriteLatency = new TimeStatisticImpl(this.writeLatency, "unsynchedWriteLatency", "The amount of time that is spent waiting for a non synch record to be written to the Journal");
    private final TimeStatisticImpl readLatency = new TimeStatisticImpl("readLatency", "The amount of time that is spent waiting for a record to be read from the Journal");
    private final CountStatisticImpl readBytesCounter = new CountStatisticImpl("readBytesCounter", "The number of bytes that have been read by the Journal");
    private final CountStatisticImpl readRecordsCounter = new CountStatisticImpl("readRecordsCounter", "The number of records that have been read by the Journal");
    private final TimeStatisticImpl cursorLatency = new TimeStatisticImpl("nextRecordLocationLatency", "The amount of time that is spent waiting to locate the next record location from the Journal");
    private final CountStatisticImpl cursorCounter = new CountStatisticImpl("nextRecordLocationCounter", "The number of times the the next record was located in the Journal");
    private final Journal next;
    private boolean detailedStats;

    public JournalStatsFilter(Journal next) {
        this.next = next;
    }

    public RecordLocation write(Packet data, boolean sync) throws IOException {
        long start = System.currentTimeMillis();
        RecordLocation answer = this.next.write(data, sync);
        long end = System.currentTimeMillis();
        this.writeRecordsCounter.increment();
        this.writeBytesCounter.add(data.remaining());
        if (sync) {
            this.synchedWriteLatency.addTime(end - start);
        } else {
            this.unsynchedWriteLatency.addTime(end - start);
        }
        return answer;
    }

    public Packet read(RecordLocation location) throws InvalidRecordLocationException, IOException {
        long start = System.currentTimeMillis();
        Packet answer = this.next.read(location);
        long end = System.currentTimeMillis();
        this.readRecordsCounter.increment();
        this.readBytesCounter.add(answer.remaining());
        this.readLatency.addTime(end - start);
        return answer;
    }

    public void setMark(RecordLocation recordLocator, boolean force) throws InvalidRecordLocationException, IOException {
        this.next.setMark(recordLocator, force);
    }

    public RecordLocation getMark() {
        return this.next.getMark();
    }

    public void close() throws IOException {
        this.next.close();
    }

    public void setJournalEventListener(JournalEventListener eventListener) {
        this.next.setJournalEventListener(eventListener);
    }

    public RecordLocation getNextRecordLocation(RecordLocation lastLocation) throws IOException, InvalidRecordLocationException {
        long start = System.currentTimeMillis();
        RecordLocation rc = this.next.getNextRecordLocation(lastLocation);
        long end = System.currentTimeMillis();
        this.cursorCounter.increment();
        this.cursorLatency.addTime(end - start);
        return rc;
    }

    public void dump(IndentPrinter out) {
        out.printIndent();
        out.println("Journal Stats {");
        out.incrementIndent();
        out.printIndent();
        out.println("Write Throughput           : " + this.getWriteThroughputKps() + " k/s and " + this.getWriteThroughputRps() + " records/s");
        out.printIndent();
        out.println("Write Latency with force   : " + this.getAvgSyncedLatencyMs() + " ms");
        out.printIndent();
        out.println("Write Latency without force: " + this.getAvgUnSyncedLatencyMs() + " ms");
        out.printIndent();
        out.println("Read Throughput            : " + this.getReadThroughputKps() + " k/s and " + this.getReadThroughputRps() + " records/s");
        out.printIndent();
        out.println("Read Latency               : " + this.getAvgReadLatencyMs() + " ms");
        out.printIndent();
        out.println("Cursor Latency             : " + this.getAvgCursorLatencyMs() + " ms");
        out.printIndent();
        out.println("Raw Stats {");
        out.incrementIndent();
        out.printIndent();
        out.println(this.writeRecordsCounter);
        out.printIndent();
        out.println(this.writeBytesCounter);
        out.printIndent();
        out.println(this.writeLatency);
        out.incrementIndent();
        out.printIndent();
        out.println(this.synchedWriteLatency);
        out.printIndent();
        out.println(this.unsynchedWriteLatency);
        out.decrementIndent();
        out.printIndent();
        out.println(this.readBytesCounter);
        out.printIndent();
        out.println(this.readLatency);
        out.decrementIndent();
        out.printIndent();
        out.println("}");
        out.decrementIndent();
        out.printIndent();
        out.println("}");
    }

    public String toString() {
        if (this.detailedStats) {
            StringWriter w = new StringWriter();
            PrintWriter pw = new PrintWriter(w);
            this.dump(new IndentPrinter(pw, "  "));
            return w.getBuffer().toString();
        }
        StringWriter w = new StringWriter();
        PrintWriter pw = new PrintWriter(w);
        IndentPrinter out = new IndentPrinter(pw, "  ");
        out.printIndent();
        out.println("Write Throughput           : " + this.getWriteThroughputKps() + " k/s and " + this.getWriteThroughputRps() + " records/s");
        out.printIndent();
        out.println("Write Latency with force   : " + this.getAvgSyncedLatencyMs() + " ms");
        out.printIndent();
        out.println("Write Latency without force: " + this.getAvgUnSyncedLatencyMs() + " ms");
        out.printIndent();
        out.println("Read Throughput            : " + this.getReadThroughputKps() + " k/s and " + this.getReadThroughputRps() + " records/s");
        out.printIndent();
        out.println("Read Latency               : " + this.getAvgReadLatencyMs() + " ms");
        out.printIndent();
        out.println("Cursor Latency       : " + this.getAvgCursorLatencyMs() + " ms");
        return w.getBuffer().toString();
    }

    public JournalStatsFilter enableDetailedStats(boolean detailedStats) {
        this.detailedStats = detailedStats;
        return this;
    }

    public double getWriteThroughputKps() {
        long totalTime = this.writeBytesCounter.getLastSampleTime() - this.writeBytesCounter.getStartTime();
        return (double)this.writeBytesCounter.getCount() / (double)totalTime / 1024.0 * 1000.0;
    }

    public double getWriteThroughputRps() {
        long totalTime = this.writeRecordsCounter.getLastSampleTime() - this.writeRecordsCounter.getStartTime();
        return (double)this.writeRecordsCounter.getCount() / (double)totalTime * 1000.0;
    }

    public double getReadThroughputKps() {
        long totalTime = this.readBytesCounter.getLastSampleTime() - this.readBytesCounter.getStartTime();
        return (double)this.readBytesCounter.getCount() / (double)totalTime / 1024.0 * 1000.0;
    }

    public double getReadThroughputRps() {
        long totalTime = this.readRecordsCounter.getLastSampleTime() - this.readRecordsCounter.getStartTime();
        return (double)this.readRecordsCounter.getCount() / (double)totalTime * 1000.0;
    }

    public double getWritesPerSecond() {
        return this.writeLatency.getAveragePerSecond();
    }

    public double getAvgCursorLatencyMs() {
        return this.cursorLatency.getAverageTime();
    }

    public double getAvgSyncedLatencyMs() {
        return this.synchedWriteLatency.getAverageTime();
    }

    public double getAvgReadLatencyMs() {
        return this.readLatency.getAverageTime();
    }

    public double getAvgUnSyncedLatencyMs() {
        return this.unsynchedWriteLatency.getAverageTime();
    }

    public void reset() {
        this.writeLatency.reset();
        this.writeBytesCounter.reset();
        this.writeRecordsCounter.reset();
        this.synchedWriteLatency.reset();
        this.unsynchedWriteLatency.reset();
        this.readLatency.reset();
        this.readBytesCounter.reset();
    }
}

