/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.perf;

import javax.jms.Connection;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class Consumer
implements Runnable {
    private static final Log LOG = LogFactory.getLog(Consumer.class);

    Consumer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Connection connection = null;
        Session session = null;
        TopicSubscriber consumer = null;
        try {
            ActiveMQConnectionFactory amq = new ActiveMQConnectionFactory("tcp://localhost:62616");
            connection = amq.createConnection();
            connection.setClientID("tmielke");
            connection.setExceptionListener(new ExceptionListener(){

                public void onException(JMSException e) {
                    e.printStackTrace();
                }
            });
            connection.start();
            session = connection.createSession(false, 1);
            Topic destination = session.createTopic("TEST.FOO");
            consumer = session.createDurableSubscriber(destination, "tmielke");
            long counter = 0L;
            for (int i = 0; i < 10000; ++i) {
                Message message2 = consumer.receive();
                if (message2 instanceof TextMessage) {
                    TextMessage textMessage = (TextMessage)message2;
                    String text = textMessage.getText();
                } else {
                    LOG.error((Object)("Received message of unsupported type. Expecting TextMessage. " + message2));
                }
                if (++counter % 1000L != 0L) continue;
                LOG.info((Object)("received " + counter + " messages"));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error in Consumer: " + e));
            return;
        }
        finally {
            try {
                if (consumer != null) {
                    consumer.close();
                }
                if (session != null) {
                    session.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception ex) {
                LOG.error((Object)("Error closing down JMS objects: " + ex));
            }
        }
    }
}

