/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.command;

import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.activemq.command.ActiveMQBytesMessage;

public class ActiveMQBytesMessageTest
extends TestCase {
    public ActiveMQBytesMessageTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(ActiveMQBytesMessageTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetDataStructureType() {
        ActiveMQBytesMessage msg = new ActiveMQBytesMessage();
        ActiveMQBytesMessageTest.assertEquals((byte)msg.getDataStructureType(), (byte)24);
    }

    public void testGetBodyLength() {
        ActiveMQBytesMessage msg = new ActiveMQBytesMessage();
        int len = 10;
        try {
            for (int i = 0; i < len; ++i) {
                msg.writeLong(5L);
            }
        }
        catch (JMSException ex) {
            ex.printStackTrace();
        }
        try {
            msg.reset();
            ActiveMQBytesMessageTest.assertTrue((msg.getBodyLength() == (long)(len * 8) ? 1 : 0) != 0);
        }
        catch (Throwable e) {
            e.printStackTrace();
            ActiveMQBytesMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadBoolean() {
        ActiveMQBytesMessage msg = new ActiveMQBytesMessage();
        try {
            msg.writeBoolean(true);
            msg.reset();
            ActiveMQBytesMessageTest.assertTrue((boolean)msg.readBoolean());
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQBytesMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadByte() {
        ActiveMQBytesMessage msg = new ActiveMQBytesMessage();
        try {
            msg.writeByte((byte)2);
            msg.reset();
            ActiveMQBytesMessageTest.assertTrue((msg.readByte() == 2 ? 1 : 0) != 0);
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQBytesMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadUnsignedByte() {
        ActiveMQBytesMessage msg = new ActiveMQBytesMessage();
        try {
            msg.writeByte((byte)2);
            msg.reset();
            ActiveMQBytesMessageTest.assertTrue((msg.readUnsignedByte() == 2 ? 1 : 0) != 0);
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQBytesMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadShort() {
        ActiveMQBytesMessage msg = new ActiveMQBytesMessage();
        try {
            msg.writeShort((short)3000);
            msg.reset();
            ActiveMQBytesMessageTest.assertTrue((msg.readShort() == 3000 ? 1 : 0) != 0);
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQBytesMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadUnsignedShort() {
        ActiveMQBytesMessage msg = new ActiveMQBytesMessage();
        try {
            msg.writeShort((short)3000);
            msg.reset();
            ActiveMQBytesMessageTest.assertTrue((msg.readUnsignedShort() == 3000 ? 1 : 0) != 0);
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQBytesMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadChar() {
        ActiveMQBytesMessage msg = new ActiveMQBytesMessage();
        try {
            msg.writeChar('a');
            msg.reset();
            ActiveMQBytesMessageTest.assertTrue((msg.readChar() == 'a' ? 1 : 0) != 0);
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQBytesMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadInt() {
        ActiveMQBytesMessage msg = new ActiveMQBytesMessage();
        try {
            msg.writeInt(3000);
            msg.reset();
            ActiveMQBytesMessageTest.assertTrue((msg.readInt() == 3000 ? 1 : 0) != 0);
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQBytesMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadLong() {
        ActiveMQBytesMessage msg = new ActiveMQBytesMessage();
        try {
            msg.writeLong(3000L);
            msg.reset();
            ActiveMQBytesMessageTest.assertTrue((msg.readLong() == 3000L ? 1 : 0) != 0);
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQBytesMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadFloat() {
        ActiveMQBytesMessage msg = new ActiveMQBytesMessage();
        try {
            msg.writeFloat(3.3f);
            msg.reset();
            ActiveMQBytesMessageTest.assertTrue((msg.readFloat() == 3.3f ? 1 : 0) != 0);
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQBytesMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadDouble() {
        ActiveMQBytesMessage msg = new ActiveMQBytesMessage();
        try {
            msg.writeDouble(3.3);
            msg.reset();
            ActiveMQBytesMessageTest.assertTrue((msg.readDouble() == 3.3 ? 1 : 0) != 0);
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQBytesMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadUTF() {
        ActiveMQBytesMessage msg = new ActiveMQBytesMessage();
        try {
            String str = "this is a test";
            msg.writeUTF(str);
            msg.reset();
            ActiveMQBytesMessageTest.assertTrue((boolean)msg.readUTF().equals(str));
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQBytesMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadBytesbyteArray() {
        ActiveMQBytesMessage msg = new ActiveMQBytesMessage();
        try {
            byte[] data = new byte[50];
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)i;
            }
            msg.writeBytes(data);
            msg.reset();
            byte[] test = new byte[data.length];
            msg.readBytes(test);
            for (int i = 0; i < test.length; ++i) {
                ActiveMQBytesMessageTest.assertTrue((test[i] == i ? 1 : 0) != 0);
            }
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQBytesMessageTest.assertTrue((boolean)false);
        }
    }

    public void testWriteObject() throws JMSException {
        ActiveMQBytesMessage msg = new ActiveMQBytesMessage();
        try {
            msg.writeObject((Object)"fred");
            msg.writeObject((Object)Boolean.TRUE);
            msg.writeObject((Object)Character.valueOf('q'));
            msg.writeObject((Object)1);
            msg.writeObject((Object)3);
            msg.writeObject((Object)3);
            msg.writeObject((Object)300L);
            msg.writeObject((Object)new Float(3.3f));
            msg.writeObject((Object)new Double(3.3));
            msg.writeObject((Object)new byte[3]);
        }
        catch (MessageFormatException mfe) {
            ActiveMQBytesMessageTest.fail((String)"objectified primitives should be allowed");
        }
        try {
            msg.writeObject(new Object());
            ActiveMQBytesMessageTest.fail((String)"only objectified primitives are allowed");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
    }

    public void testClearBody() throws JMSException {
        ActiveMQBytesMessage bytesMessage = new ActiveMQBytesMessage();
        try {
            bytesMessage.writeInt(1);
            bytesMessage.clearBody();
            ActiveMQBytesMessageTest.assertFalse((boolean)bytesMessage.isReadOnlyBody());
            bytesMessage.writeInt(1);
            bytesMessage.readInt();
        }
        catch (MessageNotReadableException mnwe) {
        }
        catch (MessageNotWriteableException mnwe) {
            ActiveMQBytesMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReset() throws JMSException {
        ActiveMQBytesMessage message = new ActiveMQBytesMessage();
        try {
            message.writeDouble(24.5);
            message.writeLong(311L);
        }
        catch (MessageNotWriteableException mnwe) {
            ActiveMQBytesMessageTest.fail((String)"should be writeable");
        }
        message.reset();
        try {
            ActiveMQBytesMessageTest.assertTrue((boolean)message.isReadOnlyBody());
            ActiveMQBytesMessageTest.assertEquals((double)message.readDouble(), (double)24.5, (double)0.0);
            ActiveMQBytesMessageTest.assertEquals((long)message.readLong(), (long)311L);
        }
        catch (MessageNotReadableException mnre) {
            ActiveMQBytesMessageTest.fail((String)"should be readable");
        }
        try {
            message.writeInt(33);
            ActiveMQBytesMessageTest.fail((String)"should throw exception");
        }
        catch (MessageNotWriteableException messageNotWriteableException) {
            // empty catch block
        }
    }

    public void testReadOnlyBody() throws JMSException {
        ActiveMQBytesMessage message = new ActiveMQBytesMessage();
        try {
            message.writeBoolean(true);
            message.writeByte((byte)1);
            message.writeByte((byte)1);
            message.writeBytes(new byte[1]);
            message.writeBytes(new byte[3], 0, 2);
            message.writeChar('a');
            message.writeDouble(1.5);
            message.writeFloat(1.5f);
            message.writeInt(1);
            message.writeLong(1L);
            message.writeObject((Object)"stringobj");
            message.writeShort((short)1);
            message.writeShort((short)1);
            message.writeUTF("utfstring");
        }
        catch (MessageNotWriteableException mnwe) {
            ActiveMQBytesMessageTest.fail((String)"Should be writeable");
        }
        message.reset();
        try {
            message.readBoolean();
            message.readByte();
            message.readUnsignedByte();
            message.readBytes(new byte[1]);
            message.readBytes(new byte[2], 2);
            message.readChar();
            message.readDouble();
            message.readFloat();
            message.readInt();
            message.readLong();
            message.readUTF();
            message.readShort();
            message.readUnsignedShort();
            message.readUTF();
        }
        catch (MessageNotReadableException mnwe) {
            ActiveMQBytesMessageTest.fail((String)"Should be readable");
        }
        try {
            message.writeBoolean(true);
            ActiveMQBytesMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            message.writeByte((byte)1);
            ActiveMQBytesMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            message.writeBytes(new byte[1]);
            ActiveMQBytesMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            message.writeBytes(new byte[3], 0, 2);
            ActiveMQBytesMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            message.writeChar('a');
            ActiveMQBytesMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            message.writeDouble(1.5);
            ActiveMQBytesMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            message.writeFloat(1.5f);
            ActiveMQBytesMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            message.writeInt(1);
            ActiveMQBytesMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            message.writeLong(1L);
            ActiveMQBytesMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            message.writeObject((Object)"stringobj");
            ActiveMQBytesMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            message.writeShort((short)1);
            ActiveMQBytesMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            message.writeUTF("utfstring");
            ActiveMQBytesMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException messageNotWriteableException) {
            // empty catch block
        }
    }

    public void testWriteOnlyBody() throws JMSException {
        ActiveMQBytesMessage message = new ActiveMQBytesMessage();
        message.clearBody();
        try {
            message.writeBoolean(true);
            message.writeByte((byte)1);
            message.writeByte((byte)1);
            message.writeBytes(new byte[1]);
            message.writeBytes(new byte[3], 0, 2);
            message.writeChar('a');
            message.writeDouble(1.5);
            message.writeFloat(1.5f);
            message.writeInt(1);
            message.writeLong(1L);
            message.writeObject((Object)"stringobj");
            message.writeShort((short)1);
            message.writeShort((short)1);
            message.writeUTF("utfstring");
        }
        catch (MessageNotWriteableException mnwe) {
            ActiveMQBytesMessageTest.fail((String)"Should be writeable");
        }
        try {
            message.readBoolean();
            ActiveMQBytesMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotReadableException mnwe) {
            // empty catch block
        }
        try {
            message.readByte();
            ActiveMQBytesMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotReadableException e) {
            // empty catch block
        }
        try {
            message.readUnsignedByte();
            ActiveMQBytesMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotReadableException e) {
            // empty catch block
        }
        try {
            message.readBytes(new byte[1]);
            ActiveMQBytesMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotReadableException e) {
            // empty catch block
        }
        try {
            message.readBytes(new byte[2], 2);
            ActiveMQBytesMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotReadableException e) {
            // empty catch block
        }
        try {
            message.readChar();
            ActiveMQBytesMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotReadableException e) {
            // empty catch block
        }
        try {
            message.readDouble();
            ActiveMQBytesMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotReadableException e) {
            // empty catch block
        }
        try {
            message.readFloat();
            ActiveMQBytesMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotReadableException e) {
            // empty catch block
        }
        try {
            message.readInt();
            ActiveMQBytesMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotReadableException e) {
            // empty catch block
        }
        try {
            message.readLong();
            ActiveMQBytesMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotReadableException e) {
            // empty catch block
        }
        try {
            message.readUTF();
            ActiveMQBytesMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotReadableException e) {
            // empty catch block
        }
        try {
            message.readShort();
            ActiveMQBytesMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotReadableException e) {
            // empty catch block
        }
        try {
            message.readUnsignedShort();
            ActiveMQBytesMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotReadableException e) {
            // empty catch block
        }
        try {
            message.readUTF();
            ActiveMQBytesMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotReadableException messageNotReadableException) {
            // empty catch block
        }
    }
}

