/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;

public class StompConnection {
    public static final long RECEIVE_TIMEOUT = 10000L;
    private Socket stompSocket;
    private ByteArrayOutputStream inputBuffer = new ByteArrayOutputStream();

    public void open(String host, int port) throws IOException, UnknownHostException {
        this.open(new Socket(host, port));
    }

    public void open(Socket socket) {
        this.stompSocket = socket;
    }

    public void close() throws IOException {
        if (this.stompSocket != null) {
            this.stompSocket.close();
            this.stompSocket = null;
        }
    }

    public void sendFrame(String data) throws Exception {
        byte[] bytes = data.getBytes("UTF-8");
        OutputStream outputStream = this.stompSocket.getOutputStream();
        outputStream.write(bytes);
        outputStream.write(0);
        outputStream.flush();
    }

    public String receiveFrame() throws Exception {
        return this.receiveFrame(10000L);
    }

    private String receiveFrame(long timeOut) throws Exception {
        this.stompSocket.setSoTimeout((int)timeOut);
        InputStream is = this.stompSocket.getInputStream();
        int c = 0;
        while (true) {
            if ((c = is.read()) < 0) {
                throw new IOException("socket closed.");
            }
            if (c == 0) {
                c = is.read();
                if (c != 10) {
                    throw new IOException("Expecting stomp frame to terminate with \u0000\n");
                }
                byte[] ba = this.inputBuffer.toByteArray();
                this.inputBuffer.reset();
                return new String(ba, "UTF-8");
            }
            this.inputBuffer.write(c);
        }
    }

    public Socket getStompSocket() {
        return this.stompSocket;
    }

    public void setStompSocket(Socket stompSocket) {
        this.stompSocket = stompSocket;
    }
}

