/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.peer;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.util.MessageIdList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PeerTransportTest
extends TestCase {
    protected static final int MESSAGE_COUNT = 50;
    protected static final int NUMBER_IN_CLUSTER = 3;
    private static final Log LOG = LogFactory.getLog(PeerTransportTest.class);
    protected ActiveMQDestination destination;
    protected boolean topic = true;
    protected int deliveryMode = 1;
    protected MessageProducer[] producers;
    protected Connection[] connections;
    protected MessageIdList[] messageIdList;

    protected void setUp() throws Exception {
        this.connections = new Connection[3];
        this.producers = new MessageProducer[3];
        this.messageIdList = new MessageIdList[3];
        ActiveMQDestination destination = this.createDestination();
        String root = System.getProperty("activemq.store.dir");
        for (int i = 0; i < 3; ++i) {
            this.connections[i] = this.createConnection(i);
            this.connections[i].setClientID("ClusterTest" + i);
            this.connections[i].start();
            Session session = this.connections[i].createSession(false, 1);
            this.producers[i] = session.createProducer(destination);
            this.producers[i].setDeliveryMode(this.deliveryMode);
            MessageConsumer consumer = this.createMessageConsumer(session, destination);
            this.messageIdList[i] = new MessageIdList();
            consumer.setMessageListener(this.messageIdList[i]);
        }
        LOG.info("Waiting for cluster to be fully connected");
        ActiveMQTopic advisoryDest = AdvisorySupport.getConsumerAdvisoryTopic(destination);
        for (int i = 0; i < 3; ++i) {
            Session session = this.connections[i].createSession(false, 1);
            MessageConsumer consumer = this.createMessageConsumer(session, advisoryDest);
            int j = 0;
            while (j < 3) {
                ActiveMQMessage message = (ActiveMQMessage)consumer.receive(1000L);
                if (message == null) {
                    PeerTransportTest.fail((String)("Connection " + i + " saw " + j + " consumers, expected: " + 3));
                }
                if (message.getDataStructure() == null || message.getDataStructure().getDataStructureType() != 5) continue;
                ++j;
            }
            session.close();
        }
        LOG.info("Cluster is online.");
    }

    protected void tearDown() throws Exception {
        if (this.connections != null) {
            for (int i = 0; i < this.connections.length; ++i) {
                this.connections[i].close();
            }
        }
    }

    protected MessageConsumer createMessageConsumer(Session session, Destination destination) throws JMSException {
        return session.createConsumer(destination);
    }

    protected Connection createConnection(int i) throws JMSException {
        LOG.info("creating connection ....");
        ActiveMQConnectionFactory fac = new ActiveMQConnectionFactory("peer://" + ((Object)((Object)this)).getClass().getName() + "/node" + i);
        return fac.createConnection();
    }

    protected ActiveMQDestination createDestination() {
        return this.createDestination(((Object)((Object)this)).getClass().getName());
    }

    protected ActiveMQDestination createDestination(String name) {
        if (this.topic) {
            return new ActiveMQTopic(name);
        }
        return new ActiveMQQueue(name);
    }

    public void testSendReceive() throws Exception {
        int i;
        for (i = 0; i < 50; ++i) {
            for (int x = 0; x < this.producers.length; ++x) {
                ActiveMQTextMessage textMessage = new ActiveMQTextMessage();
                textMessage.setText("MSG-NO: " + i + " in cluster: " + x);
                this.producers[x].send(textMessage);
            }
        }
        for (i = 0; i < 3; ++i) {
            this.messageIdList[i].assertMessagesReceived(this.expectedReceiveCount());
        }
    }

    protected int expectedReceiveCount() {
        return 150;
    }
}

