/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.thread;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.activemq.thread.PooledTaskRunner;
import org.apache.activemq.thread.Task;

public class PooledTaskRunnerTest
extends TestCase {
    private ExecutorService executor;

    protected void setUp() throws Exception {
        super.setUp();
        this.executor = Executors.newCachedThreadPool();
    }

    protected void tearDown() throws Exception {
        this.executor.shutdownNow();
        super.tearDown();
    }

    public void testNormalBehavior() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        PooledTaskRunner runner = new PooledTaskRunner(this.executor, new Task(){

            public boolean iterate() {
                latch.countDown();
                return false;
            }
        }, 1);
        runner.wakeup();
        PooledTaskRunnerTest.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS));
        runner.shutdown();
    }

    public void testWakeupResultsInThreadSafeCalls() throws Exception {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){

            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, PooledTaskRunnerTest.this.getName());
                thread.setDaemon(true);
                thread.setPriority(5);
                return thread;
            }
        });
        final CountDownLatch doneLatch = new CountDownLatch(100);
        final AtomicInteger clashCount = new AtomicInteger();
        final AtomicInteger count = new AtomicInteger();
        final PooledTaskRunner runner = new PooledTaskRunner(executor, new Task(){
            String threadUnSafeVal = null;

            public boolean iterate() {
                if (this.threadUnSafeVal != null) {
                    clashCount.incrementAndGet();
                }
                this.threadUnSafeVal = Thread.currentThread().getName();
                count.incrementAndGet();
                doneLatch.countDown();
                if (!this.threadUnSafeVal.equals(Thread.currentThread().getName())) {
                    clashCount.incrementAndGet();
                }
                this.threadUnSafeVal = null;
                return false;
            }
        }, 1);
        Runnable doWakeup = new Runnable(){

            public void run() {
                try {
                    runner.wakeup();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        int iterations = 1000;
        for (int i = 0; i < 1000; ++i) {
            if (i % 100 == 0) {
                Thread.sleep(10L);
            }
            executor.execute(doWakeup);
        }
        doneLatch.await(20L, TimeUnit.SECONDS);
        PooledTaskRunnerTest.assertEquals((String)"thread safety clash", (int)0, (int)clashCount.get());
        PooledTaskRunnerTest.assertTrue((String)"called more than once", (count.get() > 1 ? 1 : 0) != 0);
        runner.shutdown();
    }

    public void testShutsDownAfterRunnerFailure() throws Exception {
        Future<Object> future = this.executor.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                final CountDownLatch latch = new CountDownLatch(1);
                PooledTaskRunner runner = new PooledTaskRunner(PooledTaskRunnerTest.this.executor, new Task(){

                    public boolean iterate() {
                        latch.countDown();
                        throw new RuntimeException();
                    }
                }, 1);
                runner.wakeup();
                Assert.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS));
                runner.shutdown();
                return null;
            }
        });
        try {
            future.get(5L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            PooledTaskRunnerTest.fail((String)"TaskRunner did not shut down cleanly");
        }
    }
}

