/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web;

import java.util.LinkedList;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Session;

public class SessionPool {
    private ConnectionFactory connectionFactory;
    private Connection connection;
    private LinkedList<Session> sessions = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws JMSException {
        if (this.checkConnection()) {
            return this.connection;
        }
        SessionPool sessionPool = this;
        synchronized (sessionPool) {
            this.connection = this.getConnectionFactory().createConnection();
            this.connection.start();
            return this.connection;
        }
    }

    private boolean checkConnection() {
        if (this.connection == null) {
            return false;
        }
        try {
            this.connection.getMetaData();
            return true;
        }
        catch (JMSException e) {
            return false;
        }
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public ConnectionFactory getConnectionFactory() {
        if (this.connectionFactory == null) {
            throw new IllegalStateException("No ConnectionFactory has been set for the session pool");
        }
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session borrowSession() throws JMSException {
        Session answer = null;
        LinkedList<Session> linkedList = this.sessions;
        synchronized (linkedList) {
            answer = this.sessions.isEmpty() ? this.createSession() : this.sessions.removeLast();
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnSession(Session session) {
        if (session != null) {
            LinkedList<Session> linkedList = this.sessions;
            synchronized (linkedList) {
                this.sessions.add(session);
            }
        }
    }

    protected Session createSession() throws JMSException {
        return this.getConnection().createSession(false, 1);
    }
}

