/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.connection;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TransactionInProgressException;
import org.springframework.jms.connection.ConnectionFactoryUtils;
import org.springframework.util.Assert;

public class TransactionAwareConnectionFactoryProxy
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory {
    private boolean synchedLocalTransactionAllowed = false;
    private ConnectionFactory targetConnectionFactory;
    static /* synthetic */ Class class$javax$jms$Session;
    static /* synthetic */ Class class$javax$jms$QueueSession;
    static /* synthetic */ Class class$javax$jms$TopicSession;
    static /* synthetic */ Class class$org$springframework$jms$connection$SessionProxy;

    public TransactionAwareConnectionFactoryProxy() {
    }

    public TransactionAwareConnectionFactoryProxy(ConnectionFactory targetConnectionFactory) {
        this.setTargetConnectionFactory(targetConnectionFactory);
    }

    public final void setTargetConnectionFactory(ConnectionFactory targetConnectionFactory) {
        Assert.notNull((Object)targetConnectionFactory, (String)"targetConnectionFactory must not be nul");
        this.targetConnectionFactory = targetConnectionFactory;
    }

    protected ConnectionFactory getTargetConnectionFactory() {
        return this.targetConnectionFactory;
    }

    public void setSynchedLocalTransactionAllowed(boolean synchedLocalTransactionAllowed) {
        this.synchedLocalTransactionAllowed = synchedLocalTransactionAllowed;
    }

    protected boolean isSynchedLocalTransactionAllowed() {
        return this.synchedLocalTransactionAllowed;
    }

    public Connection createConnection() throws JMSException {
        Connection targetConnection = this.targetConnectionFactory.createConnection();
        return this.getTransactionAwareConnectionProxy(targetConnection);
    }

    public Connection createConnection(String username, String password) throws JMSException {
        Connection targetConnection = this.targetConnectionFactory.createConnection(username, password);
        return this.getTransactionAwareConnectionProxy(targetConnection);
    }

    public QueueConnection createQueueConnection() throws JMSException {
        if (!(this.targetConnectionFactory instanceof QueueConnectionFactory)) {
            throw new IllegalStateException("'targetConnectionFactory' is no QueueConnectionFactory");
        }
        QueueConnection targetConnection = ((QueueConnectionFactory)this.targetConnectionFactory).createQueueConnection();
        return (QueueConnection)this.getTransactionAwareConnectionProxy((Connection)targetConnection);
    }

    public QueueConnection createQueueConnection(String username, String password) throws JMSException {
        if (!(this.targetConnectionFactory instanceof QueueConnectionFactory)) {
            throw new IllegalStateException("'targetConnectionFactory' is no QueueConnectionFactory");
        }
        QueueConnection targetConnection = ((QueueConnectionFactory)this.targetConnectionFactory).createQueueConnection(username, password);
        return (QueueConnection)this.getTransactionAwareConnectionProxy((Connection)targetConnection);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        if (!(this.targetConnectionFactory instanceof TopicConnectionFactory)) {
            throw new IllegalStateException("'targetConnectionFactory' is no TopicConnectionFactory");
        }
        TopicConnection targetConnection = ((TopicConnectionFactory)this.targetConnectionFactory).createTopicConnection();
        return (TopicConnection)this.getTransactionAwareConnectionProxy((Connection)targetConnection);
    }

    public TopicConnection createTopicConnection(String username, String password) throws JMSException {
        if (!(this.targetConnectionFactory instanceof TopicConnectionFactory)) {
            throw new IllegalStateException("'targetConnectionFactory' is no TopicConnectionFactory");
        }
        TopicConnection targetConnection = ((TopicConnectionFactory)this.targetConnectionFactory).createTopicConnection(username, password);
        return (TopicConnection)this.getTransactionAwareConnectionProxy((Connection)targetConnection);
    }

    private Connection getTransactionAwareConnectionProxy(Connection target) {
        ArrayList<Class> classes = new ArrayList<Class>(3);
        classes.add(Connection.class);
        if (target instanceof QueueConnection) {
            classes.add(QueueConnection.class);
        }
        if (target instanceof TopicConnection) {
            classes.add(TopicConnection.class);
        }
        return (Connection)Proxy.newProxyInstance(this.getClass().getClassLoader(), classes.toArray(new Class[classes.size()]), (InvocationHandler)new TransactionAwareConnectionInvocationHandler(target));
    }

    private static class CloseSuppressingSessionInvocationHandler
    implements InvocationHandler {
        private final Session target;

        public CloseSuppressingSessionInvocationHandler(Session target) {
            this.target = target;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("getTargetSession")) {
                return this.target;
            }
            if (method.getName().equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(this.hashCode());
            }
            if (method.getName().equals("commit")) {
                throw new TransactionInProgressException("Commit call not allowed within a managed transaction");
            }
            if (method.getName().equals("rollback")) {
                throw new TransactionInProgressException("Rollback call not allowed within a managed transaction");
            }
            if (method.getName().equals("close")) {
                return null;
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }

    private class TransactionAwareConnectionInvocationHandler
    implements InvocationHandler {
        private final Connection target;

        public TransactionAwareConnectionInvocationHandler(Connection target) {
            this.target = target;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Session session;
            if ((class$javax$jms$Session == null ? (class$javax$jms$Session = TransactionAwareConnectionFactoryProxy.class$("javax.jms.Session")) : class$javax$jms$Session).equals(method.getReturnType())) {
                session = ConnectionFactoryUtils.getTransactionalSession(TransactionAwareConnectionFactoryProxy.this.getTargetConnectionFactory(), this.target, TransactionAwareConnectionFactoryProxy.this.isSynchedLocalTransactionAllowed());
                if (session != null) {
                    return this.getCloseSuppressingSessionProxy(session);
                }
            } else if ((class$javax$jms$QueueSession == null ? (class$javax$jms$QueueSession = TransactionAwareConnectionFactoryProxy.class$("javax.jms.QueueSession")) : class$javax$jms$QueueSession).equals(method.getReturnType())) {
                session = ConnectionFactoryUtils.getTransactionalQueueSession((QueueConnectionFactory)TransactionAwareConnectionFactoryProxy.this.getTargetConnectionFactory(), (QueueConnection)this.target, TransactionAwareConnectionFactoryProxy.this.isSynchedLocalTransactionAllowed());
                if (session != null) {
                    return this.getCloseSuppressingSessionProxy(session);
                }
            } else if ((class$javax$jms$TopicSession == null ? (class$javax$jms$TopicSession = TransactionAwareConnectionFactoryProxy.class$("javax.jms.TopicSession")) : class$javax$jms$TopicSession).equals(method.getReturnType())) {
                session = ConnectionFactoryUtils.getTransactionalTopicSession((TopicConnectionFactory)TransactionAwareConnectionFactoryProxy.this.getTargetConnectionFactory(), (TopicConnection)this.target, TransactionAwareConnectionFactoryProxy.this.isSynchedLocalTransactionAllowed());
                if (session != null) {
                    return this.getCloseSuppressingSessionProxy(session);
                }
            } else {
                if (method.getName().equals("equals")) {
                    return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
                }
                if (method.getName().equals("hashCode")) {
                    return new Integer(this.hashCode());
                }
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }

        private Session getCloseSuppressingSessionProxy(Session target) {
            ArrayList<Class> classes = new ArrayList<Class>(3);
            classes.add(class$org$springframework$jms$connection$SessionProxy == null ? (class$org$springframework$jms$connection$SessionProxy = TransactionAwareConnectionFactoryProxy.class$("org.springframework.jms.connection.SessionProxy")) : class$org$springframework$jms$connection$SessionProxy);
            if (target instanceof QueueSession) {
                classes.add(class$javax$jms$QueueSession == null ? (class$javax$jms$QueueSession = TransactionAwareConnectionFactoryProxy.class$("javax.jms.QueueSession")) : class$javax$jms$QueueSession);
            }
            if (target instanceof TopicSession) {
                classes.add(class$javax$jms$TopicSession == null ? (class$javax$jms$TopicSession = TransactionAwareConnectionFactoryProxy.class$("javax.jms.TopicSession")) : class$javax$jms$TopicSession);
            }
            return (Session)Proxy.newProxyInstance((class$org$springframework$jms$connection$SessionProxy == null ? (class$org$springframework$jms$connection$SessionProxy = TransactionAwareConnectionFactoryProxy.class$("org.springframework.jms.connection.SessionProxy")) : class$org$springframework$jms$connection$SessionProxy).getClassLoader(), classes.toArray(new Class[classes.size()]), (InvocationHandler)new CloseSuppressingSessionInvocationHandler(target));
        }
    }
}

