/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.test.TestSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DurableConsumerCloseAndReconnectTest
extends TestSupport {
    protected static final long RECEIVE_TIMEOUT = 5000L;
    private static final Log LOG = LogFactory.getLog(DurableConsumerCloseAndReconnectTest.class);
    private Connection connection;
    private Session session;
    private MessageConsumer consumer;
    private MessageProducer producer;
    private Destination destination;
    private int messageCount;

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory("vm://localhost?broker.deleteAllMessagesOnStartup=false");
    }

    public void testCreateDurableConsumerCloseThenReconnect() throws Exception {
        Connection dummyConnection = this.createConnection();
        dummyConnection.start();
        this.consumeMessagesDeliveredWhileConsumerClosed();
        dummyConnection.close();
        this.consumeMessagesDeliveredWhileConsumerClosed();
        ActiveMQConnectionFactory fac = new ActiveMQConnectionFactory("vm://localhost?broker.deleteAllMessagesOnStartup=true");
        dummyConnection = fac.createConnection();
        dummyConnection.start();
        dummyConnection.close();
    }

    protected void consumeMessagesDeliveredWhileConsumerClosed() throws Exception {
        this.makeConsumer();
        this.closeConsumer();
        this.publish();
        Thread.sleep(1000L);
        this.makeConsumer();
        Message message = this.consumer.receive(5000L);
        DurableConsumerCloseAndReconnectTest.assertTrue((String)"Should have received a message!", (message != null ? 1 : 0) != 0);
        this.closeConsumer();
        LOG.info((Object)"Now lets create the consumer again and because we didn't ack, we should get it again");
        this.makeConsumer();
        message = this.consumer.receive(5000L);
        DurableConsumerCloseAndReconnectTest.assertTrue((String)"Should have received a message!", (message != null ? 1 : 0) != 0);
        message.acknowledge();
        this.closeConsumer();
        LOG.info((Object)"Now lets create the consumer again and because we didn't ack, we should get it again");
        this.makeConsumer();
        message = this.consumer.receive(2000L);
        DurableConsumerCloseAndReconnectTest.assertTrue((String)"Should have no more messages left!", (message == null ? 1 : 0) != 0);
        this.closeConsumer();
        LOG.info((Object)"Lets publish one more message now");
        this.publish();
        this.makeConsumer();
        message = this.consumer.receive(5000L);
        DurableConsumerCloseAndReconnectTest.assertTrue((String)"Should have received a message!", (message != null ? 1 : 0) != 0);
        message.acknowledge();
        this.closeConsumer();
    }

    protected void publish() throws Exception {
        this.connection = this.createConnection();
        this.connection.start();
        this.session = this.connection.createSession(false, 2);
        this.destination = this.createDestination();
        this.producer = this.session.createProducer(this.destination);
        this.producer.setDeliveryMode(2);
        TextMessage msg = this.session.createTextMessage("This is a test: " + this.messageCount++);
        this.producer.send((Message)msg);
        this.producer.close();
        this.producer = null;
        this.closeSession();
    }

    protected Destination createDestination() throws JMSException {
        if (this.isTopic()) {
            return this.session.createTopic(this.getSubject());
        }
        return this.session.createQueue(this.getSubject());
    }

    protected boolean isTopic() {
        return true;
    }

    protected void closeConsumer() throws JMSException {
        this.consumer.close();
        this.consumer = null;
        this.closeSession();
    }

    protected void closeSession() throws JMSException {
        this.session.close();
        this.session = null;
        this.connection.close();
        this.connection = null;
    }

    protected void makeConsumer() throws Exception {
        String durableName = this.getName();
        String clientID = this.getSubject();
        LOG.info((Object)("Creating a durable subscribe for clientID: " + clientID + " and durable name: " + durableName));
        this.createSession(clientID);
        this.consumer = this.createConsumer(durableName);
    }

    private MessageConsumer createConsumer(String durableName) throws JMSException {
        if (this.destination instanceof Topic) {
            return this.session.createDurableSubscriber((Topic)this.destination, durableName);
        }
        return this.session.createConsumer(this.destination);
    }

    protected void createSession(String clientID) throws Exception {
        this.connection = this.createConnection();
        this.connection.setClientID(clientID);
        this.connection.start();
        this.session = this.connection.createSession(false, 2);
        this.destination = this.createDestination();
    }
}

