/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.spring;

import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.spring.SpringTestSupport;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringTest
extends SpringTestSupport {
    public void testSenderWithSpringXmlEmbeddedPooledBrokerConfiguredViaXml() throws Exception {
        String config = "spring-embedded-pooled.xml";
        Thread.currentThread().setContextClassLoader(SpringTest.class.getClassLoader());
        ClassPathXmlApplicationContext context1 = new ClassPathXmlApplicationContext(config);
        BrokerService bs1 = (BrokerService)context1.getBean("broker1");
        SpringTest.assertNotNull((Object)bs1);
        BrokerService bs2 = (BrokerService)context1.getBean("broker2");
        SpringTest.assertNotNull((Object)bs1);
        SpringTest.assertEquals((Object)bs1, (Object)bs2);
        ClassPathXmlApplicationContext context2 = new ClassPathXmlApplicationContext(config);
        BrokerService bs3 = (BrokerService)context2.getBean("broker1");
        SpringTest.assertNotNull((Object)bs3);
        BrokerService bs4 = (BrokerService)context2.getBean("broker2");
        SpringTest.assertNotNull((Object)bs4);
        SpringTest.assertEquals((Object)bs1, (Object)bs3);
        SpringTest.assertEquals((Object)bs1, (Object)bs4);
        SpringTest.assertTrue((boolean)bs1.isStarted());
        context2.close();
        SpringTest.assertTrue((boolean)bs1.isStarted());
        context1.close();
        SpringTest.assertFalse((boolean)bs1.isStarted());
    }

    public void testSenderWithSpringXml() throws Exception {
        String config = "spring.xml";
        this.assertSenderConfig(config);
    }

    public void testSenderWithSpringXmlAndQueue() throws Exception {
        String config = "spring-queue.xml";
        this.assertSenderConfig(config);
    }

    public void testSenderWithSpringXmlUsingJNDI() throws Exception {
        String config = "spring-jndi.xml";
        this.assertSenderConfig(config);
    }

    public void testSenderWithSpringXmlEmbeddedBrokerConfiguredViaXml() throws Exception {
        String config = "spring-embedded.xml";
        this.assertSenderConfig(config);
    }

    public void testSenderWithSpringXmlUsingSpring2NamespacesWithEmbeddedBrokerConfiguredViaXml() throws Exception {
        String config = "spring-embedded-xbean.xml";
        this.assertSenderConfig(config);
    }

    public void testSenderWithSpringXmlUsingSpring2NamespacesWithEmbeddedBrokerConfiguredViaXmlUsingLocalXsd() throws Exception {
        String config = "spring-embedded-xbean-local.xml";
        this.assertSenderConfig(config);
    }
}

