/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.proxy;

import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.broker.StubConnection;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.proxy.ProxyTestSupport;

public class ProxyConnectorTest
extends ProxyTestSupport {
    public ActiveMQDestination destination;
    public byte destinationType;
    public int deliveryMode;

    public static Test suite() {
        return ProxyConnectorTest.suite(ProxyConnectorTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ProxyConnectorTest.suite());
    }

    public void setUp() throws Exception {
        super.setAutoFail(true);
        super.setUp();
    }

    public void initCombosForTestSendAndConsume() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
        this.addCombinationValues("destinationType", new Object[]{(byte)2});
    }

    public void testSendAndConsume() throws Exception {
        StubConnection connection1 = this.createProxyConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo1);
        connection1.send((Command)connectionInfo1);
        connection1.send((Command)sessionInfo1);
        connection1.send((Command)producerInfo);
        this.destination = this.createDestinationInfo(connection1, connectionInfo1, this.destinationType);
        ConsumerInfo consumerInfo1 = this.createConsumerInfo(sessionInfo1, this.destination);
        connection1.send((Command)consumerInfo1);
        StubConnection connection2 = this.createRemoteProxyConnection();
        ConnectionInfo connectionInfo2 = this.createConnectionInfo();
        SessionInfo sessionInfo2 = this.createSessionInfo(connectionInfo2);
        connection2.send((Command)connectionInfo2);
        connection2.send((Command)sessionInfo2);
        ConsumerInfo consumerInfo2 = this.createConsumerInfo(sessionInfo2, this.destination);
        connection2.send((Command)consumerInfo2);
        try {
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        connection1.request((Command)this.createMessage(producerInfo, this.destination, this.deliveryMode));
        Message m = this.receiveMessage(connection1);
        ProxyConnectorTest.assertNotNull((Object)m);
        this.assertNoMessagesLeft(connection1);
        m = this.receiveMessage(connection2);
        ProxyConnectorTest.assertNotNull((Object)m);
        this.assertNoMessagesLeft(connection2);
    }
}

