/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.perf;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class Producer
implements Runnable {
    private static final Log LOG = LogFactory.getLog(Producer.class);

    Producer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Connection connection = null;
        Session session = null;
        MessageProducer producer = null;
        try {
            ActiveMQConnectionFactory amq = new ActiveMQConnectionFactory("tcp://localhost:61616");
            connection = amq.createConnection();
            connection.setExceptionListener(new ExceptionListener(){

                public void onException(JMSException e) {
                    e.printStackTrace();
                }
            });
            connection.start();
            session = connection.createSession(false, 1);
            Topic destination = session.createTopic("TEST.FOO");
            producer = session.createProducer((Destination)destination);
            producer.setDeliveryMode(2);
            long counter = 0L;
            for (int i = 0; i < 10000; ++i) {
                String text = "Hello world! From: " + Thread.currentThread().getName() + " : " + this.hashCode() + ":" + counter;
                TextMessage message = session.createTextMessage(text);
                producer.send((Message)message);
                if (++counter % 1000L != 0L) continue;
                LOG.info((Object)("sent " + counter + " messages"));
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            return;
        }
        finally {
            try {
                if (producer != null) {
                    producer.close();
                }
                if (session != null) {
                    session.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Problem closing down JMS objects: " + e));
            }
        }
    }
}

