/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import junit.framework.TestCase;
import org.apache.activemq.kaha.ListContainer;
import org.apache.activemq.kaha.Store;
import org.apache.activemq.kaha.StoreFactory;

public class ListContainerTest
extends TestCase {
    protected static final int COUNT = 10;
    protected String name = "test";
    protected Store store;
    protected ListContainer<Object> container;
    protected LinkedList<Object> testList;

    public void testSize() throws Exception {
        this.container.addAll(this.testList);
        ListContainerTest.assertEquals((int)this.container.size(), (int)this.testList.size());
    }

    public void testAddFirst() throws Exception {
        this.container.addAll(this.testList);
        ListContainerTest.assertEquals((int)this.container.size(), (int)this.testList.size());
        String first = "first";
        this.container.addFirst((Object)first);
        ListContainerTest.assertEquals((Object)first, (Object)this.container.get(0));
        ListContainerTest.assertEquals((int)this.container.size(), (int)(this.testList.size() + 1));
    }

    public void testAddLast() throws Exception {
        this.container.addAll(this.testList);
        ListContainerTest.assertEquals((int)this.container.size(), (int)this.testList.size());
        String last = "last";
        this.container.addLast((Object)last);
        ListContainerTest.assertEquals((Object)last, (Object)this.container.get(this.testList.size()));
        ListContainerTest.assertEquals((int)this.container.size(), (int)(this.testList.size() + 1));
    }

    public void testRemoveFirst() throws Exception {
        this.container.addAll(this.testList);
        ListContainerTest.assertEquals((int)this.container.size(), (int)this.testList.size());
        ListContainerTest.assertEquals((Object)this.testList.get(0), (Object)this.container.removeFirst());
        ListContainerTest.assertEquals((int)this.container.size(), (int)(this.testList.size() - 1));
        for (int i = 1; i < this.testList.size(); ++i) {
            ListContainerTest.assertEquals((Object)this.testList.get(i), (Object)this.container.get(i - 1));
        }
    }

    public void testRemoveLast() throws Exception {
        this.container.addAll(this.testList);
        ListContainerTest.assertEquals((int)this.container.size(), (int)this.testList.size());
        ListContainerTest.assertEquals((Object)this.testList.get(this.testList.size() - 1), (Object)this.container.removeLast());
        ListContainerTest.assertEquals((int)this.container.size(), (int)(this.testList.size() - 1));
        for (int i = 0; i < this.testList.size() - 1; ++i) {
            ListContainerTest.assertEquals((Object)this.testList.get(i), (Object)this.container.get(i));
        }
    }

    public void testIterator() throws Exception {
        this.container.addAll(this.testList);
        Iterator j = this.container.iterator();
        Iterator i = this.testList.iterator();
        while (i.hasNext()) {
            ListContainerTest.assertEquals(i.next(), j.next());
        }
        i = this.container.iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
        assert (this.container.isEmpty());
    }

    public void testIsEmpty() throws Exception {
        ListContainerTest.assertTrue((boolean)this.container.isEmpty());
    }

    public void testContains() throws Exception {
        this.container.addAll(this.testList);
        Iterator i = this.testList.iterator();
        while (i.hasNext()) {
            ListContainerTest.assertTrue((boolean)this.container.contains(i.next()));
        }
    }

    public void testToArray() throws Exception {
        this.container.addAll(this.testList);
        Object[] a = this.testList.toArray();
        Object[] b = this.container.toArray();
        ListContainerTest.assertEquals((int)a.length, (int)b.length);
        for (int i = 0; i < a.length; ++i) {
            ListContainerTest.assertEquals((Object)a[i], (Object)b[i]);
        }
    }

    public void testRemoveObject() throws Exception {
        this.container.addAll(this.testList);
        ListContainerTest.assertEquals((int)this.container.size(), (int)this.testList.size());
        for (int i = 0; i < this.testList.size(); ++i) {
            this.container.remove(this.testList.get(i));
        }
        ListContainerTest.assertTrue((boolean)this.container.isEmpty());
    }

    public void testContainsAll() throws Exception {
        this.container.addAll(this.testList);
        ListContainerTest.assertTrue((boolean)this.container.containsAll(this.testList));
    }

    public void testRemoveAll() throws Exception {
        this.container.addAll(this.testList);
        ListContainerTest.assertEquals((int)this.testList.size(), (int)this.container.size());
        this.container.removeAll(this.testList);
        ListContainerTest.assertTrue((boolean)this.container.isEmpty());
    }

    public void testRetainAll() throws Exception {
        this.container.addAll(this.testList);
        ListContainerTest.assertEquals((int)this.testList.size(), (int)this.container.size());
        this.testList.remove(0);
        this.container.retainAll(this.testList);
        ListContainerTest.assertEquals((int)this.testList.size(), (int)this.container.size());
    }

    public void testClear() throws Exception {
        this.container.addAll(this.testList);
        ListContainerTest.assertEquals((int)this.testList.size(), (int)this.container.size());
        this.container.clear();
        ListContainerTest.assertTrue((boolean)this.container.isEmpty());
    }

    public void testGet() throws Exception {
        this.container.addAll(this.testList);
        for (int i = 0; i < this.testList.size(); ++i) {
            ListContainerTest.assertEquals((Object)this.container.get(i), (Object)this.testList.get(i));
        }
    }

    public void testSet() throws Exception {
        this.container.addAll(this.testList);
    }

    public void testAddIntE() throws Exception {
        this.container.addAll(this.testList);
        ListContainerTest.assertTrue((boolean)this.container.equals(this.testList));
        String testObj = "testObj";
        int index = 0;
        this.testList.set(index, testObj);
        this.container.set(index, (Object)testObj);
        ListContainerTest.assertTrue((boolean)this.container.equals(this.testList));
        index = this.testList.size() - 1;
        this.testList.set(index, testObj);
        this.container.set(index, (Object)testObj);
        ListContainerTest.assertTrue((boolean)this.container.equals(this.testList));
    }

    public void testRemoveInt() throws Exception {
        this.container.addAll(this.testList);
        ListContainerTest.assertTrue((boolean)this.container.equals(this.testList));
        this.testList.remove(0);
        this.container.remove(0);
        ListContainerTest.assertTrue((boolean)this.container.equals(this.testList));
        int pos = this.testList.size() - 1;
        this.testList.remove(pos);
        this.container.remove(pos);
        ListContainerTest.assertTrue((boolean)this.container.equals(this.testList));
    }

    public void testIndexOf() throws Exception {
        this.container.addAll(this.testList);
        ListContainerTest.assertTrue((boolean)this.container.equals(this.testList));
        for (int i = 0; i < this.testList.size(); ++i) {
            Object o = this.testList.get(i);
            ListContainerTest.assertEquals((int)i, (int)this.container.indexOf(o));
        }
    }

    public void testListIterator() throws Exception {
        this.container.addAll(this.testList);
        ListIterator containerIter = this.container.listIterator();
        ListIterator testIter = this.testList.listIterator();
        ListContainerTest.assertTrue((boolean)testIter.hasNext());
        ListContainerTest.assertTrue((boolean)containerIter.hasNext());
        while (testIter.hasNext()) {
            Object o1 = testIter.next();
            Object o2 = containerIter.next();
            ListContainerTest.assertEquals(o1, o2);
            testIter.remove();
            containerIter.remove();
        }
        ListContainerTest.assertTrue((boolean)this.testList.isEmpty());
        ListContainerTest.assertTrue((boolean)this.container.isEmpty());
    }

    public void testListIteratorInt() throws Exception {
        this.container.addAll(this.testList);
        int start = this.testList.size() / 2;
        ListIterator containerIter = this.container.listIterator(start);
        ListIterator<Object> testIter = this.testList.listIterator(start);
        ListContainerTest.assertTrue((boolean)testIter.hasNext());
        ListContainerTest.assertTrue((boolean)containerIter.hasNext());
        while (testIter.hasNext()) {
            Object o1 = testIter.next();
            Object o2 = containerIter.next();
            ListContainerTest.assertEquals((Object)o1, o2);
        }
    }

    public void testSubList() throws Exception {
        this.container.addAll(this.testList);
        int start = this.testList.size() / 2;
        List l1 = this.testList.subList(start, this.testList.size());
        List l2 = this.container.subList(start, this.testList.size());
        ListContainerTest.assertEquals((int)l1.size(), (int)l2.size());
        ListContainerTest.assertEquals(l1, (Object)l2);
    }

    protected Store getStore() throws IOException {
        return StoreFactory.open((String)this.name, (String)"rw");
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.name = System.getProperty("basedir", ".") + "/target/activemq-data/list-container.db";
        StoreFactory.delete((String)this.name);
        this.store = this.getStore();
        this.store.deleteListContainer((Object)this.name);
        this.container = this.store.getListContainer((Object)this.name);
        this.container.load();
        this.testList = new LinkedList();
        for (int i = 0; i < 10; ++i) {
            String value = "value:" + i;
            this.testList.add(value);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.store != null) {
            this.store.close();
        }
        ListContainerTest.assertTrue((boolean)StoreFactory.delete((String)this.name));
    }
}

