/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jndi;

import java.util.Properties;
import javax.naming.InitialContext;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InitialContextTest
extends TestCase {
    private static final Log LOG = LogFactory.getLog(InitialContextTest.class);

    public void testInitialContext() throws Exception {
        InitialContext context = new InitialContext();
        InitialContextTest.assertTrue((String)"Created context", (context != null ? 1 : 0) != 0);
        ActiveMQConnectionFactory connectionFactory = (ActiveMQConnectionFactory)context.lookup("ConnectionFactory");
        InitialContextTest.assertTrue((String)"Should have created a ConnectionFactory", (connectionFactory != null ? 1 : 0) != 0);
        LOG.info((Object)("Created with brokerURL: " + connectionFactory.getBrokerURL()));
    }

    public void testUsingStandardJNDIKeys() throws Exception {
        Properties properties = new Properties();
        properties.put("java.naming.factory.initial", "org.apache.activemq.jndi.ActiveMQInitialContextFactory");
        String expected = "tcp://localhost:65432";
        properties.put("java.naming.provider.url", expected);
        InitialContext context = new InitialContext(properties);
        InitialContextTest.assertTrue((String)"Created context", (context != null ? 1 : 0) != 0);
        ActiveMQConnectionFactory connectionFactory = (ActiveMQConnectionFactory)context.lookup("ConnectionFactory");
        InitialContextTest.assertTrue((String)"Should have created a ConnectionFactory", (connectionFactory != null ? 1 : 0) != 0);
        InitialContextTest.assertEquals((String)"the brokerURL should match", (String)expected, (String)connectionFactory.getBrokerURL());
    }

    public void testConnectionFactoryPolicyConfig() throws Exception {
        Properties properties = new Properties();
        properties.put("java.naming.factory.initial", "org.apache.activemq.jndi.ActiveMQInitialContextFactory");
        properties.put("java.naming.provider.url", "tcp://localhost:65432");
        properties.put("prefetchPolicy.queuePrefetch", "777");
        properties.put("redeliveryPolicy.maximumRedeliveries", "15");
        properties.put("redeliveryPolicy.backOffMultiplier", "32");
        InitialContext context = new InitialContext(properties);
        InitialContextTest.assertTrue((String)"Created context", (context != null ? 1 : 0) != 0);
        ActiveMQConnectionFactory connectionFactory = (ActiveMQConnectionFactory)context.lookup("ConnectionFactory");
        InitialContextTest.assertTrue((String)"Should have created a ConnectionFactory", (connectionFactory != null ? 1 : 0) != 0);
        InitialContextTest.assertEquals((int)777, (int)connectionFactory.getPrefetchPolicy().getQueuePrefetch());
        InitialContextTest.assertEquals((int)15, (int)connectionFactory.getRedeliveryPolicy().getMaximumRedeliveries());
        InitialContextTest.assertEquals((int)32, (int)connectionFactory.getRedeliveryPolicy().getBackOffMultiplier());
    }
}

