/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.camel.component;

import java.util.List;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.camel.component.ActiveMQComponent;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelTemplate;
import org.apache.camel.Component;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.BrowsableEndpoint;
import org.apache.camel.util.CamelContextHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AutoExposeQueuesInCamelTest
extends EmbeddedBrokerTestSupport {
    private static final transient Log LOG = LogFactory.getLog(AutoExposeQueuesInCamelTest.class);
    protected ActiveMQQueue sampleQueue = new ActiveMQQueue("foo.bar");
    protected ActiveMQTopic sampleTopic = new ActiveMQTopic("cheese");
    protected CamelContext camelContext = new DefaultCamelContext();
    protected CamelTemplate template;

    public void testWorks() throws Exception {
        Thread.sleep(2000L);
        LOG.debug((Object)"Looking for endpoints...");
        List endpoints = CamelContextHelper.getSingletonEndpoints((CamelContext)this.camelContext, BrowsableEndpoint.class);
        for (BrowsableEndpoint endpoint : endpoints) {
            LOG.debug((Object)("Endpoint: " + endpoint));
        }
        AutoExposeQueuesInCamelTest.assertEquals((String)("Should have found an endpoint: " + endpoints), (int)1, (int)endpoints.size());
    }

    protected void setUp() throws Exception {
        super.setUp();
        ActiveMQComponent component = new ActiveMQComponent();
        component.setBrokerURL(this.bindAddress);
        component.setExposeAllQueues(true);
        this.camelContext.addComponent("activemq", (Component)component);
        this.camelContext.start();
    }

    protected void tearDown() throws Exception {
        this.camelContext.stop();
        super.tearDown();
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService broker = super.createBroker();
        broker.setDestinations(new ActiveMQDestination[]{this.sampleQueue, this.sampleTopic});
        return broker;
    }
}

