/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.virtual;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.spring.ConsumerBean;

public class VirtualTopicPubSubTest
extends EmbeddedBrokerTestSupport {
    private Connection connection;

    public void testVirtualTopicCreation() throws Exception {
        if (this.connection == null) {
            this.connection = this.createConnection();
        }
        this.connection.start();
        ConsumerBean messageList = new ConsumerBean();
        messageList.setVerbose(true);
        String queueAName = this.getVirtualTopicConsumerName();
        ActiveMQQueue queue1 = new ActiveMQQueue(queueAName);
        ActiveMQQueue queue2 = new ActiveMQQueue(queueAName);
        Session session = this.connection.createSession(false, 1);
        MessageConsumer c1 = session.createConsumer((Destination)queue1);
        MessageConsumer c2 = session.createConsumer((Destination)queue2);
        c1.setMessageListener((MessageListener)messageList);
        c2.setMessageListener((MessageListener)messageList);
        MessageProducer producer = session.createProducer((Destination)new ActiveMQTopic(this.getVirtualTopicName()));
        VirtualTopicPubSubTest.assertNotNull((Object)producer);
        int total = 10;
        for (int i = 0; i < total; ++i) {
            producer.send((Message)session.createTextMessage("message: " + i));
        }
        messageList.assertMessagesArrived(total);
    }

    protected String getVirtualTopicName() {
        return "VirtualTopic.TEST";
    }

    protected String getVirtualTopicConsumerName() {
        return "Consumer.A.VirtualTopic.TEST";
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        super.tearDown();
    }
}

