/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import org.apache.activemq.TestSupport;

public class JmsClientAckTest
extends TestSupport {
    private Connection connection;

    protected void setUp() throws Exception {
        super.setUp();
        this.connection = this.createConnection();
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
        super.tearDown();
    }

    public void testAckedMessageAreConsumed() throws JMSException {
        this.connection.start();
        Session session = this.connection.createSession(false, 2);
        Queue queue = session.createQueue(this.getQueueName());
        MessageProducer producer = session.createProducer((Destination)queue);
        producer.send((Message)session.createTextMessage("Hello"));
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        Message msg = consumer.receive(1000L);
        JmsClientAckTest.assertNotNull((Object)msg);
        msg.acknowledge();
        session.close();
        session = this.connection.createSession(false, 2);
        consumer = session.createConsumer((Destination)queue);
        msg = consumer.receive(1000L);
        JmsClientAckTest.assertNull((Object)msg);
        session.close();
    }

    public void testLastMessageAcked() throws JMSException {
        this.connection.start();
        Session session = this.connection.createSession(false, 2);
        Queue queue = session.createQueue(this.getQueueName());
        MessageProducer producer = session.createProducer((Destination)queue);
        producer.send((Message)session.createTextMessage("Hello"));
        producer.send((Message)session.createTextMessage("Hello2"));
        producer.send((Message)session.createTextMessage("Hello3"));
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        Message msg = consumer.receive(1000L);
        JmsClientAckTest.assertNotNull((Object)msg);
        msg = consumer.receive(1000L);
        JmsClientAckTest.assertNotNull((Object)msg);
        msg = consumer.receive(1000L);
        JmsClientAckTest.assertNotNull((Object)msg);
        msg.acknowledge();
        session.close();
        session = this.connection.createSession(false, 2);
        consumer = session.createConsumer((Destination)queue);
        msg = consumer.receive(1000L);
        JmsClientAckTest.assertNull((Object)msg);
        session.close();
    }

    public void testUnAckedMessageAreNotConsumedOnSessionClose() throws JMSException {
        this.connection.start();
        Session session = this.connection.createSession(false, 2);
        Queue queue = session.createQueue(this.getQueueName());
        MessageProducer producer = session.createProducer((Destination)queue);
        producer.send((Message)session.createTextMessage("Hello"));
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        Message msg = consumer.receive(1000L);
        JmsClientAckTest.assertNotNull((Object)msg);
        session.close();
        session = this.connection.createSession(false, 2);
        consumer = session.createConsumer((Destination)queue);
        msg = consumer.receive(2000L);
        JmsClientAckTest.assertNotNull((Object)msg);
        msg.acknowledge();
        session.close();
    }

    protected String getQueueName() {
        return ((Object)((Object)this)).getClass().getName() + "." + this.getName();
    }
}

