/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usage;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.activemq.Service;
import org.apache.activemq.kaha.Store;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.usage.MemoryUsage;
import org.apache.activemq.usage.StoreUsage;
import org.apache.activemq.usage.TempUsage;

public class SystemUsage
implements Service {
    private SystemUsage parent;
    private String name;
    private MemoryUsage memoryUsage;
    private StoreUsage storeUsage;
    private TempUsage tempUsage;
    private boolean sendFailIfNoSpaceExplicitySet;
    private boolean sendFailIfNoSpace;
    private List<SystemUsage> children = new CopyOnWriteArrayList<SystemUsage>();

    public SystemUsage() {
        this("default", null, null);
    }

    public SystemUsage(String name, PersistenceAdapter adapter, Store tempStore) {
        this.parent = null;
        this.name = name;
        this.memoryUsage = new MemoryUsage(name + ":memory");
        this.storeUsage = new StoreUsage(name + ":store", adapter);
        this.tempUsage = new TempUsage(name + ":temp", tempStore);
    }

    public SystemUsage(SystemUsage parent, String name) {
        this.parent = parent;
        this.name = name;
        this.memoryUsage = new MemoryUsage(parent.memoryUsage, name + ":memory");
        this.storeUsage = new StoreUsage(parent.storeUsage, name + ":store");
        this.tempUsage = new TempUsage(parent.tempUsage, name + ":temp");
    }

    public String getName() {
        return this.name;
    }

    public MemoryUsage getMemoryUsage() {
        return this.memoryUsage;
    }

    public StoreUsage getStoreUsage() {
        return this.storeUsage;
    }

    public TempUsage getTempUsage() {
        return this.tempUsage;
    }

    public String toString() {
        return "UsageManager(" + this.getName() + ")";
    }

    public void start() {
        if (this.parent != null) {
            this.parent.addChild(this);
        }
        this.memoryUsage.start();
        this.storeUsage.start();
        this.tempUsage.start();
    }

    public void stop() {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        this.memoryUsage.stop();
        this.storeUsage.stop();
        this.tempUsage.stop();
    }

    public void setSendFailIfNoSpace(boolean failProducerIfNoSpace) {
        this.sendFailIfNoSpaceExplicitySet = true;
        this.sendFailIfNoSpace = failProducerIfNoSpace;
    }

    public boolean isSendFailIfNoSpace() {
        if (this.sendFailIfNoSpaceExplicitySet || this.parent == null) {
            return this.sendFailIfNoSpace;
        }
        return this.parent.isSendFailIfNoSpace();
    }

    private void addChild(SystemUsage child) {
        this.children.add(child);
    }

    private void removeChild(SystemUsage child) {
        this.children.remove(child);
    }

    public SystemUsage getParent() {
        return this.parent;
    }

    public void setParent(SystemUsage parent) {
        this.parent = parent;
    }

    public boolean isSendFailIfNoSpaceExplicitySet() {
        return this.sendFailIfNoSpaceExplicitySet;
    }

    public void setSendFailIfNoSpaceExplicitySet(boolean sendFailIfNoSpaceExplicitySet) {
        this.sendFailIfNoSpaceExplicitySet = sendFailIfNoSpaceExplicitySet;
    }

    public void setName(String name) {
        this.name = name;
        this.memoryUsage.setName(name + ":memory");
        this.storeUsage.setName(name + ":store");
        this.tempUsage.setName(name + ":temp");
    }

    public void setMemoryUsage(MemoryUsage memoryUsage) {
        if (memoryUsage.getName() == null) {
            memoryUsage.setName(this.memoryUsage.getName());
        }
        if (this.parent != null) {
            memoryUsage.setParent(this.parent.memoryUsage);
        }
        this.memoryUsage = memoryUsage;
    }

    public void setStoreUsage(StoreUsage storeUsage) {
        if (storeUsage.getStore() == null) {
            storeUsage.setStore(this.storeUsage.getStore());
        }
        if (storeUsage.getName() == null) {
            storeUsage.setName(this.storeUsage.getName());
        }
        if (this.parent != null) {
            storeUsage.setParent(this.parent.storeUsage);
        }
        this.storeUsage = storeUsage;
    }

    public void setTempUsage(TempUsage tempDiskUsage) {
        if (tempDiskUsage.getStore() == null) {
            tempDiskUsage.setStore(this.tempUsage.getStore());
        }
        if (tempDiskUsage.getName() == null) {
            tempDiskUsage.setName(this.tempUsage.getName());
        }
        if (this.parent != null) {
            tempDiskUsage.setParent(this.parent.tempUsage);
        }
        this.tempUsage = tempDiskUsage;
    }
}

