/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.index.hash;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.kaha.Marshaller;
import org.apache.activemq.kaha.impl.index.hash.HashEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HashPage {
    static final int PAGE_HEADER_SIZE = 17;
    private static final transient Log LOG = LogFactory.getLog(HashPage.class);
    private int maximumEntries;
    private long id;
    private int binId;
    private List<HashEntry> hashIndexEntries;
    private int persistedSize;
    private long nextFreePageId = -1L;
    private boolean active = true;

    HashPage(long id, int maximumEntries) {
        this(maximumEntries);
        this.id = id;
    }

    public HashPage(int maximumEntries) {
        this.maximumEntries = maximumEntries;
        this.hashIndexEntries = new ArrayList<HashEntry>(maximumEntries);
    }

    public String toString() {
        return "HashPage[" + this.getId() + ":" + this.binId + ":" + this.id + "] size = " + this.persistedSize;
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof HashPage) {
            HashPage other = (HashPage)o;
            result = other.id == this.id;
        }
        return result;
    }

    public int hashCode() {
        return (int)this.id;
    }

    boolean isActive() {
        return this.active;
    }

    void setActive(boolean active) {
        this.active = active;
    }

    long getId() {
        return this.id;
    }

    void setId(long id) {
        this.id = id;
    }

    int getPersistedSize() {
        return this.persistedSize;
    }

    void write(Marshaller keyMarshaller, DataOutput dataOut) throws IOException {
        this.persistedSize = this.hashIndexEntries.size();
        this.writeHeader(dataOut);
        dataOut.writeInt(this.persistedSize);
        for (HashEntry entry : this.hashIndexEntries) {
            entry.write(keyMarshaller, dataOut);
        }
    }

    void read(Marshaller keyMarshaller, DataInput dataIn) throws IOException {
        this.readHeader(dataIn);
        dataIn.readInt();
        int size = this.persistedSize;
        this.hashIndexEntries.clear();
        for (int i = 0; i < size; ++i) {
            HashEntry entry = new HashEntry();
            entry.read(keyMarshaller, dataIn);
            this.hashIndexEntries.add(entry);
        }
    }

    void readHeader(DataInput dataIn) throws IOException {
        this.active = dataIn.readBoolean();
        this.nextFreePageId = dataIn.readLong();
        this.binId = dataIn.readInt();
        this.persistedSize = dataIn.readInt();
    }

    void writeHeader(DataOutput dataOut) throws IOException {
        dataOut.writeBoolean(this.isActive());
        dataOut.writeLong(this.nextFreePageId);
        dataOut.writeInt(this.binId);
        this.persistedSize = this.hashIndexEntries.size();
        dataOut.writeInt(this.persistedSize);
    }

    boolean isEmpty() {
        return this.hashIndexEntries.isEmpty();
    }

    boolean isFull() {
        return this.hashIndexEntries.size() >= this.maximumEntries;
    }

    boolean isUnderflowed() {
        return this.hashIndexEntries.size() < this.maximumEntries / 2;
    }

    boolean isOverflowed() {
        return this.hashIndexEntries.size() > this.maximumEntries;
    }

    List<HashEntry> getEntries() {
        return this.hashIndexEntries;
    }

    void setEntries(List<HashEntry> newEntries) {
        this.hashIndexEntries = newEntries;
    }

    int getMaximumEntries() {
        return this.maximumEntries;
    }

    void setMaximumEntries(int maximumEntries) {
        this.maximumEntries = maximumEntries;
    }

    int size() {
        return this.hashIndexEntries.size();
    }

    void reset() throws IOException {
        this.hashIndexEntries.clear();
        this.persistedSize = 0;
    }

    void addHashEntry(int index, HashEntry entry) throws IOException {
        this.hashIndexEntries.add(index, entry);
    }

    HashEntry getHashEntry(int index) {
        HashEntry result = this.hashIndexEntries.get(index);
        return result;
    }

    HashEntry removeHashEntry(int index) throws IOException {
        HashEntry result = this.hashIndexEntries.remove(index);
        return result;
    }

    void removeAllTreeEntries(List<HashEntry> c) {
        this.hashIndexEntries.removeAll(c);
    }

    List<HashEntry> getSubList(int from, int to) {
        return new ArrayList<HashEntry>(this.hashIndexEntries.subList(from, to));
    }

    int getBinId() {
        return this.binId;
    }

    void setBinId(int binId) {
        this.binId = binId;
    }

    String dump() {
        StringBuffer str = new StringBuffer(32);
        str.append(this.toString());
        str.append(": ");
        for (HashEntry entry : this.hashIndexEntries) {
            str.append(entry);
            str.append(",");
        }
        return str.toString();
    }
}

