/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.index.hash;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.kaha.impl.index.hash.HashEntry;
import org.apache.activemq.kaha.impl.index.hash.HashIndex;
import org.apache.activemq.kaha.impl.index.hash.HashPage;
import org.apache.activemq.kaha.impl.index.hash.HashPageInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class HashBin {
    private static final transient Log LOG = LogFactory.getLog(HashBin.class);
    private HashIndex hashIndex;
    private int id;
    private int maximumEntries;
    private int size;
    private List<HashPageInfo> hashPages = new ArrayList<HashPageInfo>();

    HashBin(HashIndex hashIndex, int id, int maximumEntries) {
        this.hashIndex = hashIndex;
        this.id = id;
        this.maximumEntries = maximumEntries;
    }

    public String toString() {
        return "HashBin[" + this.getId() + "]";
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof HashBin) {
            HashBin other = (HashBin)o;
            result = other.id == this.id;
        }
        return result;
    }

    public int hashCode() {
        return this.id;
    }

    int getId() {
        return this.id;
    }

    void setId(int id) {
        this.id = id;
    }

    boolean isEmpty() {
        return true;
    }

    int getMaximumEntries() {
        return this.maximumEntries;
    }

    void setMaximumEntries(int maximumEntries) {
        this.maximumEntries = maximumEntries;
    }

    int size() {
        return this.size;
    }

    HashPageInfo addHashPageInfo(long id, int size) throws IOException {
        HashPageInfo info = new HashPageInfo(this.hashIndex);
        info.setId(id);
        info.setSize(size);
        this.hashPages.add(info);
        this.size += size;
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashEntry find(HashEntry key) throws IOException {
        HashEntry result = null;
        try {
            int low = 0;
            int high = this.size() - 1;
            while (low <= high) {
                int mid = low + high >> 1;
                HashEntry te = this.getHashEntry(mid);
                int cmp = te.compareTo(key);
                if (cmp == 0) {
                    result = te;
                    break;
                }
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                high = mid - 1;
            }
        }
        finally {
            this.end();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean put(HashEntry newEntry) throws IOException {
        boolean replace = false;
        try {
            int low = 0;
            int high = this.size() - 1;
            while (low <= high) {
                int mid = low + high >> 1;
                HashEntry midVal = this.getHashEntry(mid);
                int cmp = midVal.compareTo(newEntry);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                replace = true;
                midVal.setIndexOffset(newEntry.getIndexOffset());
                break;
            }
            if (!replace) {
                this.addHashEntry(low, newEntry);
                ++this.size;
            }
        }
        finally {
            this.end();
        }
        return replace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HashEntry remove(HashEntry entry) throws IOException {
        HashEntry result = null;
        try {
            int low = 0;
            int high = this.size() - 1;
            while (low <= high) {
                int mid = low + high >> 1;
                HashEntry te = this.getHashEntry(mid);
                int cmp = te.compareTo(entry);
                if (cmp == 0) {
                    result = te;
                    this.removeHashEntry(mid);
                    --this.size;
                    break;
                }
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                high = mid - 1;
            }
        }
        finally {
            this.end();
        }
        return result;
    }

    private void addHashEntry(int index, HashEntry entry) throws IOException {
        HashPageInfo pageToUse = null;
        int offset = 0;
        if (index >= this.getMaximumBinSize()) {
            while (index >= this.getMaximumBinSize()) {
                HashPage hp = this.hashIndex.createPage(this.id);
                pageToUse = this.addHashPageInfo(hp.getId(), 0);
                pageToUse.setPage(hp);
            }
            offset = 0;
        } else {
            int count = 0;
            int countSoFar = 0;
            int pageNo = 0;
            for (HashPageInfo page : this.hashPages) {
                if (index < (count += page.size())) {
                    offset = index - countSoFar;
                    break;
                }
                if (index == count && page.size() + 1 <= this.maximumEntries) {
                    offset = page.size();
                    break;
                }
                countSoFar += page.size();
                ++pageNo;
            }
            while (pageNo >= this.hashPages.size()) {
                HashPage hp = this.hashIndex.createPage(this.id);
                this.addHashPageInfo(hp.getId(), 0);
            }
            pageToUse = this.hashPages.get(pageNo);
        }
        pageToUse.begin();
        pageToUse.addHashEntry(offset, entry);
        this.doOverFlow(index);
    }

    private HashEntry removeHashEntry(int index) throws IOException {
        HashPageInfo page = this.getRetrievePage(index);
        int offset = this.getRetrieveOffset(index);
        HashEntry result = page.removeHashEntry(offset);
        if (page.isEmpty()) {
            this.hashPages.remove(page);
            this.hashIndex.releasePage(page.getPage());
        }
        this.doUnderFlow(index);
        return result;
    }

    private HashEntry getHashEntry(int index) throws IOException {
        HashPageInfo page = this.getRetrievePage(index);
        page.begin();
        int offset = this.getRetrieveOffset(index);
        HashEntry result = page.getHashEntry(offset);
        return result;
    }

    private int getMaximumBinSize() {
        return this.maximumEntries * this.hashPages.size();
    }

    private HashPageInfo getRetrievePage(int index) throws IOException {
        HashPageInfo result = null;
        int count = 0;
        int pageNo = 0;
        for (HashPageInfo page : this.hashPages) {
            if (index < (count += page.size())) break;
            ++pageNo;
        }
        result = this.hashPages.get(pageNo);
        result.begin();
        return result;
    }

    private int getRetrieveOffset(int index) throws IOException {
        int result = 0;
        int count = 0;
        for (HashPageInfo page : this.hashPages) {
            if (index + 1 <= count + page.size()) {
                result = index - count;
                break;
            }
            count += page.size();
        }
        return result;
    }

    private void doOverFlow(int index) throws IOException {
        HashPageInfo info = this.getRetrievePage(index);
        if (info.size() > this.maximumEntries) {
            info.begin();
            HashEntry entry = info.removeHashEntry(info.size() - 1);
            this.doOverFlow(this.hashPages.indexOf(info) + 1, entry);
        }
    }

    private void doOverFlow(int pageNo, HashEntry entry) throws IOException {
        HashPageInfo info = null;
        if (pageNo >= this.hashPages.size()) {
            HashPage page = this.hashIndex.createPage(this.id);
            info = this.addHashPageInfo(page.getId(), 0);
            info.setPage(page);
        } else {
            info = this.hashPages.get(pageNo);
        }
        info.begin();
        info.addHashEntry(0, entry);
        if (info.size() > this.maximumEntries) {
            HashEntry overflowed = info.removeHashEntry(info.size() - 1);
            this.doOverFlow(pageNo + 1, overflowed);
        }
    }

    private void doUnderFlow(int index) {
    }

    String dump() throws IOException {
        String str = "[" + this.hashPages.size() + "]";
        for (HashPageInfo page : this.hashPages) {
            page.begin();
            str = str + page.dump();
            page.end();
        }
        return str;
    }

    private void end() throws IOException {
        for (HashPageInfo info : this.hashPages) {
            info.end();
        }
    }
}

